/************************************************************************

  File:		timestmp.c
  Function:	Provides time and date information.
  Version:	1.01
  Author:	Robert Sjoberg (SJOBRG@MIT-OZ)
  Index:
    char *timemon[]
	array of string names for months of the year, 3-char abbrevs.
    char *timedow[]
	array of string names for days of week, 3-char abbrevs.
    timestmp (tp)
	fills struct tp with time and date information.
  History:
    10/16/83 - original V1.00, inspired by a similarly named function
	written by Matthew Halfant.  This version is for IBM PC and PC
	compatibles.  Written for Computer Innovations C86 compiler.
    06/05/84 - V1.01, adapted to Unix V7 by defining symbol UNIX.

    11 Dec 85  Craig Milo Rogers at USC/ISI
	Converted to Lattice C 2.12.  Left the C86 code around in a
	conditional.

************************************************************************/

#include "timestmp.h"

#ifndef UNIX
#ifndef PCDOS
#define PCDOS			/* defaults to PC-DOS time function */
#endif
#ifndef C86
#ifndef LATTICEC
#define LATTICEC		/* defaults to the Lattice C compiler. */
#endif
#endif
#endif

char *timemon[] = {
    "",			/* not used, since months start with 1 */
    "Jan","Feb","Mar","Apr","May","Jun",
    "Jul","Aug","Sep","Oct","Nov","Dec"
};

char *timedow[] = {
    "Sun","Mon","Tue","Wed","Thu","Fri","Sat"
};

#ifdef PCDOS

#ifdef C86

timestmp (tp)
    struct timedata *tp;
/*
  Get current date and time and place them in the structure tp.
*/
{
    struct {
	char al,ah,bl,bh,cl,ch,dl,dh;
	int  si,di,ds,es;
    } REGS;

    REGS.ah = 0x2a;		/* request date */
    sysint (0x21, &REGS, &REGS);
    tp->tim_yr = ((REGS.ch & 0377) << 8) + (REGS.cl & 0377);
    tp->tim_mon = REGS.dh;
    tp->tim_dat = REGS.dl;
    tp->tim_dow = -1;		/* not defined */
    REGS.ah = 0x2c;		/* request time */
    sysint (0x21, &REGS, &REGS);
    tp->tim_hr = REGS.ch;
    tp->tim_min = REGS.cl;
    tp->tim_sec = REGS.dh;
}

#endif /* C86 */

#ifdef LATTICEC

#include <dos.h>

timestmp (tp)
    struct timedata *tp;
/*
  Get current date and time and place them in the structure tp.
*/
{
    union REGS ioregs;		/* Register image for DOS calls. */

    ioregs.h.ah = 0x2a;		/* request date */
    intdos (&ioregs, &ioregs);
    tp->tim_yr = ioregs.x.cx;
    tp->tim_mon = ioregs.h.dh;
    tp->tim_dat = ioregs.h.dl;
    tp->tim_dow = ioregs.h.al;

    ioregs.h.ah = 0x2c;		/* request time */
    intdos (&ioregs, &ioregs);
    tp->tim_hr = ioregs.h.ch;
    tp->tim_min = ioregs.h.cl;
    tp->tim_sec = ioregs.h.dh;
}

#endif /* LATTICEC */

#endif /* PCDOS */

#ifdef UNIX

#include <time.h>

timestmp (tp)
    struct timedata *tp;
/*
  Gets current date and time and places them in the structure tp.
*/
{
    struct tm t;
    extern struct tm *localtime();
    long clock;

    time (&clock);
    t = *localtime(&clock);
    tp->tim_yr = t.tm_year + 1900;
    tp->tim_mon = t.tm_mon;
    tp->tim_dat = t.tm_mday;
    tp->tim_dow = t.tm_wday;
    tp->tim_hr = t.tm_hour;
    tp->tim_min = t.tm_min;
    tp->tim_sec = t.tm_sec;
}

#endif
