/* .c                         freeware                 xhunga@tiscali.fr
*/

/* --------------------------------- INCLUDES ------------------------------- */
#include "xa_hfile.h"

/* ------------------------------------- FUNCTION --------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* Call  :                                                                    */
/* Debug :                                                                    */
/* -------------------------------------------------------------------------- */
AB()
{
double pbT[3][3*TWOCOL]=
{
   1,1,   0,1,  -2,1,
   0,1,   1,1,   0,1,
   0,1,   0,1,   1,1,
};
matrix mT={3,3*TWOCOL,&pbT[0][0]};

double pbTu[3][2*TWOCOL]=
{
   0,1,   0,1,
   0,1,   0,1,
   1,1,   1,1,
};
matrix mTu={3,2*TWOCOL,&pbTu[0][0]};

double pbu [2][2*TWOCOL];matrix mu ={2,2*TWOCOL,&pbu [0][0]};
double pbTv[3][2*TWOCOL];matrix mTv={3,2*TWOCOL,&pbTv[0][0]};
/*-------------------------------- PROGRAM ---------------------------------- */
     rndmF(&mu,6,3);
    copymF(&mu,&mTu);

  clrscrn();
  printf("\n                                          T");
  printmF3(&mT);

  printf("\n                                          u = OA");
  printmF3(&mTu);
  gnpltvectcol2d("u",&mTu);

  multmF(&mT,&mTu,&mTv);
  printf("\n                                          v = OB");
  printmF3(&mTv);
  gnpltvectcol2d("v",&mTv);
  gnpltaxis(     "aa2d.plt");

  printf("\n  To see the result in Gnuplot (gp373w32.exe) :           \n\n");
  printf("  * open the file aa2d.plt with Gnuplot. Gnuplot draw u and v. \n");
  printf("  * Press Return in this window. (To create a new value for u) \n");
  printf("  * Use the command Replot in Gnuplot to draw the news u and v.\n");
}

void hello(void)
{
  printf("\n Freeware by : xhunga bernard 06000 Nice France.  ");
  printf("\n\n\n                                              ");
  printf("\n       Horizontal shift (left) c < 0 :            ");
  printf("\n       *****************************              ");
  printf("\n\n                                                ");
  printf("\n\n                                                ");
  printf("\n                | 1  0  c |                       ");
  printf("\n           v  = | 0  1  0 |  u                    ");
  printf("\n                | 0  0  1 |                       ");
  printf("\n\n\n\n\n                                          ");
  printf("\n Distributed  by :  http://www.simtel.net/        ");
  printf("\n                                                  ");
  printf("\n Press return to continue                        \n");
  getchar();
}


/* --------------------------------- MAIN ----------------------------------- */
int main()
{
time_t t;
/*-------------------------------- PROGRAM ---------------------------------- */
  srand(time(&t));
  hello();
do
{


  AB();


  printf("\n Press 'X' Return to stop\n");
} while(toupper(getchar())!='X');

  return 0;
}












