/* .c                         freeware                 xhunga@tiscali.fr
*/

/* --------------------------------- INCLUDES ------------------------------- */
#include "xa_hfile.h"

/* ------------------------------------- FUNCTION --------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* Call  :                                                                    */
/* Debug :                                                                    */
/* -------------------------------------------------------------------------- */
AB()
{
double pbA[3][3*TWOCOL]=
{
   1,1,   0,1,   0,1,
   0,1,   0,1,   0,1,
   0,1,   0,1,   1,1,
};
matrix mA={3,3*TWOCOL,&pbA[0][0]};

double pbu  [3][2*TWOCOL];matrix mu  ={3,2*TWOCOL,&pbu  [0][0]};
double pbv  [3][2*TWOCOL];matrix mv  ={3,2*TWOCOL,&pbv  [0][0]};
double pbu_v[3][2*TWOCOL];matrix mu_v={3,2*TWOCOL,&pbu_v[0][0]};

double pb0[3][1*TWOCOL];matrix m0={3,1*TWOCOL,&pb0[0][0]};
/*-------------------------------- PROGRAM ---------------------------------- */
  rndmF(&mu,8,3);
   mzero(&m0);
  copymF(&m0,&mu);

  clrscrn();

  printf("\n Orthogonal projection on the xz-plan :           \n");
  printf("\n                |  1  0  0 |                        ");
  printf("\n           v  = |  0  0  0 |  u                     ");
  printf("\n                |  0  0  1 |                        ");

  printf("\n                                          u = OA");
  printmF(&mu);
  gnpltvectcol3d("u",&mu);

  multmF(&mA,&mu,&mv);
  printf("\n                                          v = OB");
  printmF(&mv);
  gnpltvectcol3d("v",&mv);

  copymF(&mu,&mu_v);
  copycolF(&mv,1,&mu_v,0);
  gnpltvectcol3d("u_v",&mu_v);
  gnpltvectcol3d("v_u",&mu_v);
  gnpltaxyz3d(   "axyz");
  gnpltxzpln3d(  "plnxz");
  gnpltb22xz(    "a3d.plt");

  printf("\n To see the result in Gnuplot (gp373w32.exe) :              \n\n");
  printf("  * open the file 'a3d.plt' with Gnuplot. (Gnuplot draw u and v.)\n");
  printf("  * Press Return in this window.   (To create a new value for u.)\n");
  printf("  * Use the command \"load 'a3d.plt'\" (With the arrow keyboard.)\n");
  printf("  * Gnuplot draws the news u and v vectors.\n");
}

void hello(void)
{
  printf("\n Freeware by : xhunga bernard 06000 Nice France.  ");
  printf("\n\n\n                                              ");
  printf("\n     Orthogonal projection on the xz-plan :       ");
  printf("\n     ************************************         ");
  printf("\n\n                                                ");
  printf("\n                  u = OA                          ");
  printf("\n\n                                                ");
  printf("\n                |  1  0  0 |                      ");
  printf("\n           v  = |  0  0  0 |  u                   ");
  printf("\n                |  0  0  1 |                      ");
  printf("\n\n\n\n\n                                          ");
  printf("\n Distributed  by :  http://www.simtel.net/        ");
  printf("\n                                                  ");
  printf("\n Press return to continue                        \n");
  getchar();
}


/* --------------------------------- MAIN ----------------------------------- */
int main()
{
time_t t;
/*-------------------------------- PROGRAM ---------------------------------- */
  srand(time(&t));
  hello();
do
{


  AB();


  printf("\n Press 'X' Return to stop\n");
} while(toupper(getchar())!='X');

  return 0;
}












