/* .c                         freeware                 xhunga@tiscali.fr
*/

/* --------------------------------- INCLUDES ------------------------------- */
#include "xa_hfile.h"

/* ------------------------------------- FUNCTION --------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* Call  :                                                                    */
/* Debug :                                                                    */
/* -------------------------------------------------------------------------- */
AB(
int n,
int p
)
{
fraction f1by4      = {1,4};

fraction Norm_uplsv;
fraction Norm_umnsv;
fraction Norm_f1by4uplsv;
fraction Norm_f1by4umnsv;
fraction Norm_f1by4uplsv_mns_f1by4umnsv;

fraction InnerProduct;

double pbu[MXR][MXC*TWOCOL];matrix mu={MXR,MXC*TWOCOL,&pbu[0][0]};
double pbv[MXR][MXC*TWOCOL];matrix mv={MXR,MXC*TWOCOL,&pbv[0][0]};
double puplsv[MXR][MXC*TWOCOL];matrix muplsv={MXR,MXC*TWOCOL,&puplsv[0][0]};
double pumnsv[MXR][MXC*TWOCOL];matrix mumnsv={MXR,MXC*TWOCOL,&pumnsv[0][0]};

       mu.rows = n;               mu.cols = p*TWOCOL;
       mv.rows = n;               mv.cols = p*TWOCOL;
   muplsv.rows = n;           muplsv.cols = p*TWOCOL;
   mumnsv.rows = n;           mumnsv.cols = p*TWOCOL;
/*-------------------------------- PROGRAM ---------------------------------- */
  rndmF(&mu,5,3);
  rndmF(&mv,5,3);

  clrscrn();

  printf("                                 u");
  printmF3(&mu);
  printf("                                 v");
  printmF3(&mv);

  addmF(&mu,&mv,&muplsv);
  printf("\n\n                             u + v");
  printmF3(&muplsv);

  Norm_uplsv = norm_MnmP2(&muplsv);           /* It is the square of the norm.*/
  printf("\n\n         ||u + v||**2 = %.0lf/%-.0lf\n",
            Norm_uplsv.numer,
            Norm_uplsv.denom);
  getchar();

  clrscrn();
  printf("                                 u");
  printmF3(&mu);
  printf("                                 v");
  printmF3(&mv);

  submF(&mu,&mv,&mumnsv);
  printf("\n\n                             u - v");
  printmF3(&mumnsv);

  Norm_umnsv = norm_MnmP2(&mumnsv);           /* It is the square of the norm.*/
  printf("\n\n         ||u - v||**2 = %.0lf/%-.0lf\n",
            Norm_umnsv.numer,
            Norm_umnsv.denom);
  getchar();


  clrscrn();

  printf("                           ||u + v||**2 = %.0lf/%-.0lf\n\n",
            Norm_uplsv.numer,
            Norm_uplsv.denom);

  Norm_f1by4uplsv = multF(f1by4, Norm_uplsv);
  printf("                       1/4 ||u + v||**2 = %.0lf/%-.0lf\n\n\n",
            Norm_f1by4uplsv.numer,
            Norm_f1by4uplsv.denom);

  printf("                           ||u - v||**2 = %.0lf/%-.0lf\n\n",
            Norm_umnsv.numer,
            Norm_umnsv.denom);

  Norm_f1by4umnsv = multF(f1by4, Norm_umnsv);
  printf("                       1/4 ||u - v||**2 = %.0lf/%-.0lf\n\n\n",
            Norm_f1by4umnsv.numer,
            Norm_f1by4umnsv.denom);

  printf("               If u and v are vector in Mnm     \n");
  printf("                   with the inner product :     \n\n");
  printf("    <u,v> = 1/4 ||u+v||**2  -  1/4 ||u-v||**2 \n\n\n");

  InnerProduct = innerprod_Mnm(&mu,&mv);
  printf("                                  <u,v> = %.0lf/%-.0lf\n\n",
            InnerProduct.numer,
            InnerProduct.denom);

  Norm_f1by4uplsv_mns_f1by4umnsv = subF(Norm_f1by4uplsv, Norm_f1by4umnsv);
  printf("  1/4 ||u + v||**2  -  1/4 ||u - v||**2 = %.0lf/%-.0lf\n\n",
            Norm_f1by4uplsv_mns_f1by4umnsv.numer,
            Norm_f1by4uplsv_mns_f1by4umnsv.denom);
}

void hello(void)
{
  printf("\n Freeware by : xhunga bernard 06000 Nice France.\n");
  printf("\n\n\n      If u and v are vector in Mnm           ");
  printf("\n             with the  inner product :          \n");
  printf("\n   <u,v> = 1/4 ||u+v||**2  -  1/4 ||u-v||**2      ");
  printf("\n   ***************************************    \n\n");
  printf("\n The size of u, v : 2x2 ... 5x5.                \n");
  printf("\n     ex : \"normMa.exe\"                        \n");
  printf("\n You can choose the size :                      \n");
  printf("\n     ex : \"normMa.exe 2 3\" -> 2x3               ");
  printf("\n          \"normMa.exe 4 2\" -> 4x2             \n");
  printf("\n Distributed  by :  http://www.simtel.net/        ");
  printf("\n                                                  ");
  printf("\n Press return to continue                         ");
  printf("\n                                                  ");
  getchar();
}

/* --------------------------------- MAIN ----------------------------------- */
int main(int argc, char *argv[])
{
time_t t;
int    n;
int    p;
/*-------------------------------- PROGRAM ---------------------------------- */
  srand(time(&t));
  hello();
do
{
if( argc == 3 && atoi(argv[1]) && atoi(argv[2]) )
 {
  n = atoi(argv[1]); if( n > 5){n=5;}
  p = atoi(argv[2]); if( p > 5){p=5;}
  }
else
 {
  n=rndpI(5);
  p=rndpI(5);
 }
   if(n<2){n=2;}
   if(p<2){p=2;}


  AB(n,p);


  printf("\n Press 'X' Return to stop\n");
} while(toupper(getchar())!='X');

  return 0;
}












