/* .c                         freeware                 xhunga@tiscali.fr
*/

/* --------------------------------- INCLUDES ------------------------------- */
#include "xa_hfile.h"

/* ------------------------------------- FUNCTION --------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* Call  :                                                                    */
/* Debug :                                                                    */
/* -------------------------------------------------------------------------- */
AB(
int n
)
{
fraction det;
int x;

fraction InnerProduct_u_vmnsw;
fraction InnerProduct_uv;
fraction InnerProduct_uw;
fraction InnerProduct_uvmnsuw;

double pbA   [MXR][MXC*TWOCOL];matrix mA    ={MXR,MXC*TWOCOL,&pbA   [0][0]};
double pbu   [MXR][MXC*TWOCOL];matrix mu    ={MXR,MXC*TWOCOL,&pbu   [0][0]};
double pbv   [MXR][MXC*TWOCOL];matrix mv    ={MXR,MXC*TWOCOL,&pbv   [0][0]};
double pbw   [MXR][MXC*TWOCOL];matrix mw    ={MXR,MXC*TWOCOL,&pbw   [0][0]};
double pvmnsw[MXR][MXC*TWOCOL];matrix mvmnsw={MXR,MXC*TWOCOL,&pvmnsw[0][0]};

        mA.rows = n;               mA.cols = n*TWOCOL;
        mu.rows = n;               mu.cols =   TWOCOL;
        mv.rows = n;               mv.cols =   TWOCOL;
        mw.rows = n;               mw.cols =   TWOCOL;
    mvmnsw.rows = n;           mvmnsw.cols =   TWOCOL;
/*-------------------------------- PROGRAM ---------------------------------- */
         x =   5;
 if(n<3){x = 100;}

  do
  {
               rndmF(&mA,x,2);
          det = detF(&mA);
  }while(!det.numer);

  rndmF(&mu,5,2);
  rndmF(&mv,5,2);
  rndmF(&mw,5,2);

  clrscrn();
  printf("                  An invertible matrix : A \n");
  printmF(&mA);
  getchar();

  clrscrn();
  printf("\n                               (n x 1) : u \n");
  printmF(&mu);
  printf("\n                               (n x 1) : v \n");
  printmF(&mv);
  printf("\n                               (n x 1) : w \n");
  printmF(&mw);
  getchar();

  clrscrn();
  printf("                                 V");
  printmF3(&mv);
  printf("                                 W");
  printmF3(&mw);

  printf("\n\n                             V - W");
  addmF(&mv,&mw,&mvmnsw);
  printmF3(     &mvmnsw);

  InnerProduct_u_vmnsw = innerprod_A(&mA,&mu,&mvmnsw);
  printf("\n\n <U,V-W> =  %6.0lf/%.0lf \n\n",
            InnerProduct_u_vmnsw.numer,
            InnerProduct_u_vmnsw.denom);
  getchar();

  clrscrn();
  InnerProduct_uv = innerprod_A(&mA,&mu,&mv);
  printf("\n\n         <U,V> =  %6.0lf/%.0lf \n\n",
            InnerProduct_uv.numer,
            InnerProduct_uv.denom);

  InnerProduct_uw = innerprod_A(&mA,&mu,&mw);
  printf("         <U,W> =  %6.0lf/%.0lf \n\n",
            InnerProduct_uw.numer,
            InnerProduct_uw.denom);

  InnerProduct_uvmnsuw = addF(InnerProduct_uv,InnerProduct_uw);
  printf(" <U,V> - <U,W> =  %6.0lf/%.0lf \n\n",
              InnerProduct_uvmnsuw.numer,
              InnerProduct_uvmnsuw.denom);
  getchar();

  clrscrn();
  printf("\n  Inner Product on R**n generated by A         \n");
  printf("\n          <U,V-W>  =  <U,V> - <U,W>\n\n\n\n");
  printf("       <U,V-W> =  %6.0lf/%.0lf \n\n",
            InnerProduct_u_vmnsw.numer,
            InnerProduct_u_vmnsw.denom);

  printf(" <U,V> - <U,W> =  %6.0lf/%.0lf \n\n",
              InnerProduct_uvmnsuw.numer,
              InnerProduct_uvmnsuw.denom);
}

void hello(void)
{
  printf("\n Freeware by : xhunga bernard 06000 Nice France.  ");
  printf("\n\n                                                ");
  printf("\n    Inner Product on R**n generated by A        \n");
  printf("\n\n\n                                              ");
  printf("\n          <U,V - W>  =  <U,V> - <U,W>             ");
  printf("\n          ***************************             ");
  printf("\n\n\n\n\n                                          ");
  printf("\n Distributed  by :  http://www.simtel.net/        ");
  printf("\n                                                  ");
  printf("\n Press return to continue                          ");
  printf("\n                                                  ");
  getchar();
}


/* --------------------------------- MAIN ----------------------------------- */
int main(int argc, char *argv[])
{
time_t t;
int    n;
/*-------------------------------- PROGRAM ---------------------------------- */
  srand(time(&t));
  hello();
do
{
if( argc == 2 && atoi(argv[1]) )
 {
  n = atoi(argv[1]); if( n > 5){n=5;}
  }
else
 {
  n=rndpI(5);
 }
   if(n<2){n=2;}


  AB(n);


  printf("\n Press 'X' Return to stop\n");
} while(toupper(getchar())!='X');

  return 0;
}

