/* .c                         freeware                 xhunga@tiscali.fr
*/

/* --------------------------------- INCLUDES ------------------------------- */
#include "xa_hfile.h"

/* ------------------------------------- FUNCTION --------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* Call  :                                                                    */
/* Debug :                                                                    */
/* -------------------------------------------------------------------------- */
void T(
pmatrix mA,
pmatrix mX,
pmatrix mTA)
{
 multmF(mA,mX,mTA);
}
/* ------------------------------------- FUNCTION --------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* Call  :                                                                    */
/* Debug :                                                                    */
/* -------------------------------------------------------------------------- */
void AB(int n, int p, int q)
{
fraction c;

double pbA     [MXR][MXC*TWOCOL];matrix mA       ={MXR,MXC*TWOCOL,&pbA     [0][0]};
double pbB     [MXR][MXC*TWOCOL];matrix mB       ={MXR,MXC*TWOCOL,&pbB     [0][0]};
double pbX     [MXR][MXC*TWOCOL];matrix mX       ={MXR,MXC*TWOCOL,&pbX     [0][0]};
double pbTA    [MXR][MXC*TWOCOL];matrix mTA      ={MXR,MXC*TWOCOL,&pbTA    [0][0]};
double pbTB    [MXR][MXC*TWOCOL];matrix mTB      ={MXR,MXC*TWOCOL,&pbTB    [0][0]};
double pTAplsTB[MXR][MXC*TWOCOL];matrix mTAplsTB ={MXR,MXC*TWOCOL,&pTAplsTB[0][0]};
double pAplsB  [MXR][MXC*TWOCOL];matrix mAplsB   ={MXR,MXC*TWOCOL,&pAplsB  [0][0]};
double pT_AplsB[MXR][MXC*TWOCOL];matrix mT_AplsB ={MXR,MXC*TWOCOL,&pT_AplsB[0][0]};
double pbcA    [MXR][MXC*TWOCOL];matrix mcA      ={MXR,MXC*TWOCOL,&pbcA    [0][0]};
double pbTcA   [MXR][MXC*TWOCOL];matrix mTcA     ={MXR,MXC*TWOCOL,&pbTcA   [0][0]};
double pbcTA   [MXR][MXC*TWOCOL];matrix mcTA     ={MXR,MXC*TWOCOL,&pbcTA   [0][0]};

                     mA.rows=n;                   mA.cols=p*TWOCOL;
                     mB.rows=n;                   mB.cols=p*TWOCOL;
                 mAplsB.rows=n;               mAplsB.cols=p*TWOCOL;
                    mcA.rows=n;                  mcA.cols=p*TWOCOL;
                     mX.rows=p;                   mX.cols=q*TWOCOL;
                    mTA.rows=n;                  mTA.cols=q*TWOCOL;
                    mTB.rows=n;                  mTB.cols=q*TWOCOL;
               mTAplsTB.rows=n;             mTAplsTB.cols=q*TWOCOL;
               mT_AplsB.rows=n;             mT_AplsB.cols=q*TWOCOL;
                   mTcA.rows=n;                 mTcA.cols=q*TWOCOL;
                   mcTA.rows=n;                 mcTA.cols=q*TWOCOL;
/*-------------------------------- PROGRAM ---------------------------------- */
  c = rndF (    9,1);
      rndmF(&mX,9,1);
      rndmF(&mA,9,1);
      rndmF(&mB,9,1);

  clrscrn();

  printf(" a)         T : M%dx%d -> M%dx%d, \n\n",n,p,n,q);
  printf("     T(A) = AX (where X%dx%d is a fixed matrix)\n\n",p,q);
  printf("            Is T(A) + T(B) = T(A + B) ?\n\n");
  printf("                                                       A :");
  printmI3(&mA);
  printf("                                                       B :");
  printmI3(&mB);
  printf("                                                       X :");
  printmI3(&mX);
  printf("\n\n");
  getchar();

  clrscrn();
  printf("                                                    T(A) :");
     T(&mA,&mX,&mTA);
  printmI3(&mTA);
  printf("                                                    T(B) :");
     T(&mB,&mX,&mTB);
  printmI3(&mTB);
  printf("                                             T(A) + T(B) :");
   addmF(&mTA,&mTB,&mTAplsTB);
  printmI3(       &mTAplsTB);
  printf("\n\n");

  printf("                                                   A + B :");
  addmF(&mA,&mB,&mAplsB);
  printmI3(     &mAplsB);
     T(&mAplsB,&mX,&mT_AplsB);
   printf("                                                  T(A+B):");
 printmI3(&mT_AplsB);
  getchar();

  clrscrn();
  printf(" b)          T : M%dx%d -> M%dx%d, \n\n",n,p,n,q);
  printf("    T(A) = AX (where X%dx%d is a fixed matrix)\n\n",p,q);
  printf("             Is T(cA) =  cT(A) ? \n\n");
  printf("                                                       A :");
  printmI3(&mA);
  printf("                                                       X :");
  printmI3(&mX);
  printf("                                                c = %4.0f :",c.numer);
  printf("\n\n");
  getchar();

  clrscrn();
  smultmF(c,&mA,&mcA);
  printf("                                                  %4.0fA :",c.numer);
  printmI3(&mcA);
  T(&mcA,&mX,&mTcA);
  printf("                                                   T(cA) :");
  printmI3(&mTcA);
  printf("\n\n");

  printf("                                                    T(A) :");
  T(&mA,&mX,&mTA);
  printmI3(&mTA);
  printf("                                               %4.0fT(A) :",c.numer);
  smultmF(c,&mTA,&mcTA);
  printmI3(&mcTA);
}

void hello(void)
{
  printf("\n Freeware by : xhunga bernard 06000 Nice France.\n");
  printf("\n\n\n\n\n                                        \n");
  printf("              T : Mnxp -> Mnxq,                 \n\n");
  printf("   T(A) = AX (where Xpxq is a fixed matrix)     \n\n");
  printf("         Is T a linear transformation?          \n\n");
  printf("               ****************                   \n");
  printf("\n\n\n\n                                            ");
  printf("\n Distributed  by :  http://www.simtel.net/        ");
  printf("\n                                                  ");
  printf("\n Press return to continue                         ");
  printf("\n                                                  ");
  getchar();
}


/* --------------------------------- MAIN ----------------------------------- */
main(int argc, char *argv[])
{
time_t t;
int    n;
int    p;
int    q;

/*-------------------------------- PROGRAM ---------------------------------- */
  srand(time(&t));
  hello();
do
{
if( argc == 4 && atoi(argv[1])&& atoi(argv[2]) && atoi(argv[3]) )
 {n = atoi(argv[1]); if( n > 3){n=3;}
  p = atoi(argv[2]); if( p > 3){p=3;}
  q = atoi(argv[3]); if( q > 3){q=3;}}
else
 {    n=rndpI(3);       p=rndpI(3);     q=rndpI(3);}
   if(n<1){n=1;}     if(p<1){p=1;}     if(q<1){q=1;}


  AB(n,p,q);


  printf("\n Press 'X' Return to stop\n");
} while(toupper(getchar())!='X');

  return 0;
}


