/* .c                         freeware                 xhunga@tiscali.fr
*/

/* --------------------------------- INCLUDES ------------------------------- */
#include "xa_hfile.h"

/* ------------------------------------- FUNCTION --------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* Call  :                                                                    */
/* Debug :                                                                    */
/* -------------------------------------------------------------------------- */
fraction T(
pmatrix mu,
pmatrix mu0)
{
  return(innerprod(mu,mu0));
}
/* ------------------------------------- FUNCTION --------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* Call  :                                                                    */
/* Debug :                                                                    */
/* -------------------------------------------------------------------------- */
void AB(int n)
{
fraction c;
fraction Tu;
fraction Tv;
fraction Tcu;
fraction cTu;
fraction T_uplsv;
fraction TuplsTv;

double pbu     [MXR][MXC*TWOCOL];matrix mu     ={MXR,MXC*TWOCOL,&pbu   [0][0]};
double pbu0    [MXR][MXC*TWOCOL];matrix mu0    ={MXR,MXC*TWOCOL,&pbu0  [0][0]};
double pbv     [MXR][MXC*TWOCOL];matrix mv     ={MXR,MXC*TWOCOL,&pbv   [0][0]};
double puplsv  [MXR][MXC*TWOCOL];matrix muplsv ={MXR,MXC*TWOCOL,&puplsv[0][0]};
double pbcu    [MXR][MXC*TWOCOL];matrix mcu    ={MXR,MXC*TWOCOL,&pbcu  [0][0]};

                     mu.rows=1;                   mu.cols=n*TWOCOL;
                    mu0.rows=1;                 mu0.cols=n*TWOCOL;
                     mv.rows=1;                   mv.cols=n*TWOCOL;
                 muplsv.rows=1;               muplsv.cols=n*TWOCOL;
                    mcu.rows=1;                  mcu.cols=n*TWOCOL;
/*-------------------------------- PROGRuM ---------------------------------- */
  c = rndF (     9,1);
      rndmF(&mu, 9,1);
      rndmF(&mu0,9,1);
      rndmF(&mv, 9,1);

  clrscrn();
  printf(" a)       T : V -> R, \n");
  printf("          T(u) = <u,u0> (where u0 is a fixed vector)\n");
  printf("          Is T(u) + T(v) = T(u + v) ?\n\n");
  printf("                                                      u  :");
  printmI3(&mu);
  printf("                                                      v  :");
  printmI3(&mv);
  printf("                                                      u0 :");
  printmI3(&mu0);
  Tu = T(&mu,&mu0);
  printf("\n\n T(u) = %.0lf\n", Tu.numer);
  Tv = T(&mv,&mu0);
  printf("\n T(v) = %.0lf\n", Tv.numer);
  TuplsTv = addF(Tu,Tv);
  printf("\n T(u) + T(v) = %.0lf\n", TuplsTv.numer);
  printf("\n                                                   u + v :");
  addmF(&mu,&mv,&muplsv);
  printmI3(     &muplsv);
  T_uplsv = T(&muplsv,&mu0);
  printf("\n T(u+v) = %.0lf\n", T_uplsv.numer);
  getchar();

  clrscrn();
  printf(" b)             T : V -> R, \n");
  printf("       T(u) = <u,u0> (where u0 is a fixed vector)\n");
  printf("           Is T(cu) =  cT(u) ? \n");
  printf("                                                      u :\n");
  printmI3(&mu);
  printf("                                               c = %4.0f :\n\n",c.numer);
  smultmF(c,&mu,&mcu);
  printf("                                                    cfu :\n");
  printmI3(&mcu);
  Tcu = T(&mcu,&mu0);
  printf("\n T(cu) = %.0lf\n", Tcu.numer);
  printf("\n\n");
  Tu = T(&mu,&mu0);
  printf("\n   T(u) = %.0lf\n", Tu.numer);
  cTu = multF(c,Tu);
  printf("\n  cT(u) = %.0lf\n", cTu.numer);
}

void hello(void)
{
  printf("\n Freeware by : xhunga bernard 06000 Nice France.\n");
  printf("\n\n\n\n\n                                        \n");
  printf("              T : V -> R,                       \n\n");
  printf("   T(u) = <u,u0> (where u0 is a fixed vector)   \n\n");
  printf(" Is Inner product space a linear transformation?\n\n");
  printf("               ****************                   \n");
  printf("\n\n\n\n                                            ");
  printf("\n Distributed  by :  http://www.simtel.net/        ");
  printf("\n                                                  ");
  printf("\n Press return to continue                         ");
  printf("\n                                                  ");
  getchar();
}

/* --------------------------------- MAIN ----------------------------------- */
main(int argc, char *argv[])
{
time_t t;
int    n;

/*-------------------------------- PROGRAM ---------------------------------- */
  srand(time(&t));
  hello();
do
{
if( argc == 2 && atoi(argv[1]))
 {  n = atoi(argv[1]); if( n > 4){n=4;}}
else
 {  n = rndpI(4);}
if( n < 1){n=1;}


  AB(n);


printf("\n Press 'X' Return to stop\n");
} while(toupper(getchar())!='X');

  return 0;
}



