/*======================================================================*/
/* test/demonstration program for the xmmapi.asm API code               */
/*                                                                      */
/* jan 1997 - John M. Hughes (jmh@as.arizona.edu)                       */
/*                                                                      */
/* This code is supplied as-is, where-is, with no guarantees either     */
/* express or implied. User assumes all risks. No support is available. */
/* This code is in the public domain, and may be used without           */
/* restriction.                                                         */
/*                                                                      */
/* Compiled with Microsoft C 6.00A, assembly done with MASM 6.0         */
/*                                                                      */
/* This demo is a bit noisy when it reads back 100,000 bytes worth of   */
/* data from extended memory, but it's good to see that nothing is      */
/* being mangled in the process. DON'T USE CONTROL-C! You'll leave      */
/* orphaned chunks of extended memory lying around if you do.           */
/*======================================================================*/

#include <stdio.h>
#include <conio.h>
#include <dos.h>

#include "xmmapi.h"

void main(void)
{
    short           rc;
    unsigned long   val;
    unsigned short  handle;
    unsigned char   bitval;
    short           i, j;
    unsigned char   buff[100];
    unsigned long   offset;


    puts("\nXMM API functions");
    puts("Jan 1997 - jmh@as.arizona.edu");
    puts("----------------------------------------\n");

    rc = XMMcheck();

    if (rc <= 0) {
        printf("XMMcheck failed\n"); 
        return;
        }

    val = XMMvers();
    printf("XMM version = %d.%d\n",(val & 0xff00) >> 8,val & 0x00ff);
    printf("\n");

    val = XMMlargest();
    printf("Larget block available = %lu K bytes\n",val);
    val = XMMtotal();
    printf("Total memory available = %lu K bytes\n",val);
    printf("\n");

    printf("Allocating 100 K bytes\n");
    val = XMMalloc(100);
    if (val & 0xffff0000) {
        printf("Error allocating 100K bytes from XM\n");
        return;
        }
    handle = (unsigned short) (val & 0x0000ffff);
    val = XMMlargest();
    printf("Larget block available = %lu K bytes\n",val);
    val = XMMtotal();
    printf("Total memory available = %lu K bytes\n",val);
    printf("\n");

    printf("Releasing 100 K bytes\n");
    XMMfree(handle);
    val = XMMlargest();
    printf("Larget block available = %lu K bytes\n",val);
    val = XMMtotal();
    printf("Total memory available = %lu K bytes\n",val);
    printf("\n");

    printf("Press enter to continue...");
    while (!kbhit());
    getch();

    printf("Allocating 100 K bytes\n");
    val = XMMalloc(100);
    if (val & 0xffff0000) {
        printf("Error allocating 100K bytes from XM\n");
        return;
        }
    handle = (unsigned short) (val & 0x0000ffff);
    val = XMMlargest();
    printf("Larget block available = %lu K bytes\n",val);
    val = XMMtotal();
    printf("Total memory available = %lu K bytes\n",val);
    printf("\n");

    printf("Loading extended memory\n");

    bitval = 0x20;

    for (i = 0; i < 50; i++) {
        buff[i] = bitval;
        bitval++;
        }

    bitval = 0x20;

    for (i = 50; i < 100; i++) {
        buff[i] = bitval;
        bitval++;
        }
  
    for (j = 0; j < 50; j++)
        printf("%c",buff[j]);        
    printf("\n");
    for (j = 50; j < 100; j++)
        printf("%c",buff[j]);
    printf("\n");

    offset = 0;

    for (i = 0; i < 1000; i++) {
        XMMpmove.len     = 100;
        XMMpmove.srchndl = 0;
        (unsigned char far *) XMMpmove.srcoff  = (unsigned char far *) buff;
        XMMpmove.dsthndl = handle;
        XMMpmove.dstoff  = offset;
        XMMmove();
        offset += 100;
        }

    printf("Press enter to continue...");
    while (!kbhit());
    getch();

    printf("Reading extended memory\n");

    offset = 0;

    for (i = 0; i < 1000; i++) {
        XMMpmove.len     = 100;
        XMMpmove.srchndl = handle; 
        XMMpmove.srcoff  = offset; 
        XMMpmove.dsthndl = 0;
        (unsigned char far *) XMMpmove.dstoff  = (unsigned char far *) buff;
        XMMmove();

        for (j = 0; j < 50; j++)
            printf("%c",buff[j]);        
        printf("\n");
        for (j = 50; j < 100; j++)
            printf("%c",buff[j]);
        printf("\n");

        offset += 100;
        }

    printf("Releasing 100 K bytes\n");
    XMMfree(handle);
    val = XMMlargest();
    printf("Larget block available = %lu K bytes\n",val);
    val = XMMtotal();
    printf("Total memory available = %lu K bytes\n",val);
    printf("\n");
}



