Program CDROMCOM;           {Author :    C. Enders,   1995}
                            {Bug fixes : J. da Silva, 1998}
                            {Credits : See CDROM.PAS ...  }
Uses
  CDROM;

Var
  Control : string;
  Track : byte;
  ValCode : integer;

Procedure Help;
Begin
  Writeln('Usage CDROMCOM <command> ... where command is :');
  Writeln('                   1, etc.    for Play track 1, etc.');
  Writeln('                   S          for Stop');
  Writeln('                   R          for Resume play');
  Writeln('                   O          for Open tray');
  Writeln('                   C          for Close tray');
  Writeln('                   I          for time/track Info')
End;

Procedure CDopen;
Var
  result : boolean;
Begin
  Writeln('Opening CD player...');
  result := CDEject
End;

Procedure CDclose;
Var
  result : boolean;
Begin
  Writeln('Closing CD player...');
  result := CDCloseTray
End;

Procedure StopCD;
Var
  result : boolean;
Begin
  Writeln('CD stopped.');
  result := CDStop
End;

Procedure CDshowinfo;
Var
  posinf : CDPosType;
  temp : string;
  result : boolean;
Begin
  result := CDgetpos(posinf);
  with posinf do
    begin
      str(sec, temp);
      if sec < 10
      then
        temp := '0' + temp;
      Writeln('Track : ',BCD2Byte(Track):2,' - Time : ',min:2,':',temp);
      str(dsec, temp);
      if dsec < 10
      then
        temp := '0' + temp;
      Writeln('Played total time : ',dmin:2,':',temp)
    end {with}
end;

Procedure CDresume;
Var
  result : boolean;
Begin
  Writeln('Playing CD ...');
  result := CDResumePlay;
  CDshowinfo
End;

Procedure CDplay (track : byte);
Var
  frames : longint;
  result : boolean;
Begin
  frames := CDVolSize - CDGetTrackStart(track);
  Writeln('Playing CD ...');
  result := CDPlayAudio(track,frames);
  CDshowinfo
End;

Begin
  Writeln;
  Writeln('CD-ROM commands --- version 1.1 --- FREEWARE by C.E. 95, JdS 98');
  { Get command }
  If ParamCount = 0
  Then
    Control := '1'  { Default = Play track 1 }
  Else
    Control := Paramstr(1);
  { If track number was specified, convert to value }
  Val(Control,Track,ValCode);
  If ValCode <> 0
  Then
     Track := 1;   { Default track number }
  { Execute command }
  Case Upcase(Control[1]) Of
    'O' : CDopen;
    'C' : CDclose;
    'R' : CDresume;
    'S' : StopCD;
    'I' : CDShowInfo;
    '?' : help;
    '/' : help
  Else {Case}
    CDplay(Track)
  End {Case}
End.
