
/*============================================================================

	DRIVER.H
	Device driver related strcutures and defines.
  This file is part of the

  PseudoCD package (version 02)
  Copyright (C) C.Kulms, 1997

  This is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by
  the Free Software Foundation; version 2 of the License.

  This software is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this software; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

============================================================================*/

#ifndef _DRIVER_H_
#define _DRIVER_H_

/* device driver commands */
#define DRV_MEDCHK	0x01	/* media check */
#define DRV_BPB			0x02	/* build BPB */
#define DRV_IOCTLI	0x03	/* ioctl input */
#define DRV_READ		0x04	/* read */
#define DRV_NDINP		0x05	/* nondestructive input no wait */
#define DRV_ISTAT		0x06	/* input status */
#define DRV_IFLUSH	0x07	/* input flush */
#define DRV_WRITE		0x08	/* write */
#define DRV_WRITEV	0x09	/* write with verify */
#define DRV_OSTAT		0x0A	/* output status */
#define DRV_OFLUSH	0x0B	/* output flush */
#define DRV_IOCTLO	0x0C	/* ioctl output */
#define DRV_OPEN		0x0D	/* device open */
#define DRV_CLOSE		0x0E	/* device close */
#define DRV_RMVMED	0x0F	/* removable media */
#define DRV_OUBUSY	0x10	/* output until busy */

/* device-driver status codes */
#define REQDONE					0x0100	/* successful completed */
#define DEV_BUSY				0x0200	/* device busy */
#define ERRORBIT				0x8000	/* set if error */
#define ERRORCOND				0x80FF	/* mask for error condition */
#define ERRORMASK				0x00FF	/* mask for error codes below */
#define ERR_WRITEPROT		0x0000	/* write protectition violation */
#define ERR_UNKNOWNUNIT	0x0001	/* invalid sub-unit number in request-header */
#define ERR_NOTREADY		0x0002	/* device not ready */
#define ERR_UNKNOWNCMD	0x0003	/* unknown command code in request-header */
#define ERR_CRCERROR		0x0004	/* crc-error */
#define ERR_BADRQLENGTH	0x0005	/* bad request-header length */
#define ERR_SEEKERROR		0x0006	/* seek error */
#define ERR_UNKNOWNMED	0x0007	/* unknwon media byte in request-header */
#define ERR_SECNOTFOUND	0x0008	/* sector not found */
#define ERR_OUTOFPAPER	0x0009	/* printer out of paper */
#define ERR_WRITEFAULT	0x000A	/* write fault */
#define ERR_READFAULT		0x000B	/* read fault */
#define ERR_GENFAILURE	0x000C	/* general failure */
#define ERR_INVCHANGE		0x000F	/* invalid media change */

typedef struct s_DRVHDR	/* general device-driver header */
{
	struct s_DRVHDR far	*fpLink;	/* pointer to next device-driver */
	unsigned	uAttrib;						/* attributes */
	unsigned	uStrat;							/* strategy-routine entry point */
	unsigned	uIntr;							/* interrupt-routine entry point */
	char			acName[8];					/* device-name / number of units */
}	t_DRVHDR;

typedef struct s_REQHDR		/* general request-header */
{
	unsigned char ucLength;		/* length of request header */
	char					cUnit;			/* subunit number */
	unsigned char	ucCmd;			/* command */
	unsigned			uStatus;		/* status */
	char					acRsvd[8];
}	t_REQHDR;

typedef struct s_RWREQ	/* general read/write request-header */
{
	char 			cLength;				/* length of request-header */
	char			cUnit;					/* sub-unit the request is for */
	char			cFunction;			/* requested function (read of write) */
	unsigned	uStatus;				/* status returned from driver */
	char			acRsvd[8];
	char			cMedia;					/* expected media-type */
	char far	*fpBuffer;			/* pointer to transfer-buffer */
	unsigned	uCount;					/* number of sectors to read */
	unsigned	uStartSec;			/* first sector to read (<0FFFFh) */
	char far	*fpVolumeID;		/* pointer to volume-id if disk-changed */
	unsigned long	ulHugeSec;	/* first sector to read if StartSec=0FFFFh */
}	t_RWREQ;

typedef struct sREQIOCTL	/* resquest header for IOCTL (input/output) */
{
	t_REQHDR	tReqHdr;
	char			cMedia;			/* media expected */
	char far	*fpBuffer;	/* pointer to transfer buffer */
	unsigned	uSize;			/* number of bytes/sectors to read/write */
	unsigned	uSector;		/* first sector to read/write */
	char far	*fpPtr;			/* points to volume-id if media-changed */
}	t_REQIOCTL;

#endif /* ndef _DRIVER_H_ */

