/*
 * File......: COM34.PRG
 * Author....: Steve Kolterman
 * CIS ID....: 76320,37
 * Date......: $Date:   17 Aug 1991 15:07:16  $
 * Revision..: $Revision:   1.3  $
 * Log file..: $Logfile:   E:/nanfor/src/com34.prv  $
 * 
 * This is an original work by Steve Kolterman and is placed in the
 * public domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log:   E:/nanfor/src/com34.prv  $
 * 
 *    Rev 1.3   17 Aug 1991 15:07:16   GLENN
 * Don Caton corrected some spelling errors in the doc
 * 
 *    Rev 1.2   15 Aug 1991 23:03:14   GLENN
 * Forest Belt proofread/edited/cleaned up doc
 * 
 *    Rev 1.1   14 Jun 1991 19:51:22   GLENN
 * Minor edit to file header
 * 
 *    Rev 1.0   12 Jun 1991 01:55:46   GLENN
 * Initial revision.
 *
 */

/*
 * File......: COM34.PRG
 * Author....: Steve Kolterman
 * CIS ID....: 76320,37
 * Date......: $Date:   17 Aug 1991 15:07:16  $
 * Revision..: $Revision:   1.3  $
 * Log file..: $Logfile:   E:/nanfor/src/com34.prv  $
 * 
 * This is an original work by Steve Kolterman and is placed in the
 * public domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 * 
 *    Rev 1.1   14 Jun 1991 19:51:22   GLENN
 * Minor edit to file header
 * 
 *    Rev 1.0   12 Jun 1991 01:55:46   GLENN
 * Initial revision.
 *
 */

/*  $DOC$
 *  $FUNCNAME$
 *     FT_COM3OR4()
 *  $CATEGORY$
 *     Environment
 *  $ONELINER$
 *     Enable use of COM3 and/or COM4 on IBM/PC compatables.
 *  $SYNTAX$
 *     FT_COM3OR4( <nPort> ) -> lSuccess
 *  $ARGUMENTS$
 *     <nPort> is the COM port to enable.  Ports except 3 and 4 are ignored.
 *     The default is 3.
 *  $RETURNS$
 *     a logical indicating success or failure of the operation.
 *  $DESCRIPTION$
 *     FT_COM3OR4() uses FT_POKE() to write to memory the correct data
 *     to enable COM3 or COM4 on IBM-PC compatables.  The programmer will
 *     still need to explicitly open the port with SET PRINTER or FOPEN()
 *     to send data out the port.
 *
 *     FT_COM3OR4() owes everything to FT_POKE().
 *  $EXAMPLES$
 *     // attempt to enable COM3
 *     IF FT_COM3OR4( 3 )
 *        Qout("COM3 was enabled")
 *     END
 *
 *  $END$
 */

FUNCTION FT_Com3or4( port )
  LOCAL res31, res32, res41, res42

  res31 := res32 := res41 := res42 := .T.
  port  := IF(port==NIL,3,port)

  IF port > 2 .and. port < 5
     IF port == 3
        res31 := FT_Poke(64, 4, 232); res32 := FT_Poke(64, 5, 3)
     ELSEIF port==4
        res41 := FT_Poke(64, 6, 232); res42 := FT_Poke(64, 7, 2)
     END
  END

RETURN IF(port==3,(res31 .and. res32),IF(port==4,(res41 .and. res42),.T.))

