* Function..: KEYINPUT
* Author....: Richard Low
* Syntax....: KEYINPUT( exp<N>, exp<L>, exp<L> )
* Returns...: The character string inputted.
* Parameters: p_numchars = maximum number of characters allowed in input
*             p_upcase   = force entry in upper case (.T.|.F.)
*             p_echochar = echo characters on screen (.T.|.F.)
* Notes....: Function to get character input while echoing dots on screen.

FUNCTION KEYINPUT
PARAMETERS p_numchars, p_upcase, p_echochar
PRIVATE f_str, f_i, f_key, f_c, f_mrow, f_mcol                       && hide all memvars

*-- first check and verify all parameters

p_numchars = IF( TYPE('p_numchars') = 'N', p_numchars,  80 )         && if #1 is numeric, use as width, else default to 80 characters
p_upcase   = IF( TYPE('p_upcase')   = 'L', p_upcase,   .F. )         && if #2 is logical, use as upper case flag, otherwise false
p_echochar = IF( TYPE('p_echochar') = 'L', p_echochar, .T. )         && if #3 is logical, use as the echo flag, otherwise true

f_str = ''                                                           && set up null string to hold entry
f_i   = 1

DO WHILE f_i <= p_numchars                                           && start the loop to get each char
   f_key = INKEY(0)                                                  && wait & get ASCII value of keypress

   DO CASE
      CASE f_key > 31 .AND. f_key < 127                              && if in printable character range
         f_c = IF( p_upcase, UPPER(CHR(f_key)), CHR(f_key) )         && convert to upper case if flag set
         f_str = f_str + f_c                                         && add new character onto string
         f_i = f_i + 1                                               && increment counter
         ?? IF( p_echochar, f_c, '.' )                               && echo character on screen or only a dot

      CASE f_key = 8 .AND. f_i > 1                                   && back space over an entry
         f_mrow = IF( COL() = 0, ROW()-1, ROW() )                    && if at column zero, back up to previous row
         f_mcol = IF( COL() = 0, 79, COL()-1 )                       && go to end of previous line, or just back one space
         @ f_mrow, f_mcol SAY ' '                                    && erase previous dot or character
         @ f_mrow, f_mcol SAY ''                                     && move the cursor back
         f_i = f_i - 1                                               && decrement  f_i
         f_str = IF( f_i=1, '', SUBSTR(f_str,1,f_i-1) )              && if BS to beginning, make string null, else shorten it

      CASE f_key = 13                                                && Enter key pressed
         EXIT

      CASE f_key = 27                                                && Escape key pressed
         f_str = ''                                                  && return null string
         EXIT

   ENDCASE
ENDDO
RETURN (f_str)
