/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * ATTCLOCK.C                                                              *
 *                                                                         *
 * Jonathan Senning                               September, November 1987 *
 *                                                                         *
 * This program accesses the battery operated clock on the AT&T 6300 in    *
 * order to set the the DOS date and time for non-AT&T versions of MS-DOS  *
 * or PC-DOS.  It is also used to set the the battery operated clock.      *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include <stdio.h>
#include <dos.h>
#include "ctime.h"

#define FALSE 0
#define TRUE  1

main(argc, argv)
int argc;
char *argv[];
{
    void help(char *);

    int ch;
    int info    = FALSE;
    int set     = FALSE;
    int verbose = FALSE;
    int wait    = FALSE;
    struct date today;
    struct time now;
    static char pgm[9] = {"attclock"};

    extern void getpname(char *, char *);
    extern int  getopt(int, char **, char *);

    if (_osmajor >= 3) {          /* If version 3.x dos, get program name */
        getpname(*argv, pgm);
    }

    argv[0] = pgm;                /* load into first argument for getopt() */

    while ((ch = getopt(argc, argv, "iIhHrRsSvVwW")) != EOF) {
        switch (ch) {
            case 'i' :
            case 'I' : info = TRUE;         /* info only */
                       break;
            case 'h' :
            case 'H' : help(pgm);           /* list options */
                       exit(0);
            case 'r' :
            case 'R' : reset_clock();      /* zero seconds and re-initialize */
                       exit(0);
            case 's' :
            case 'S' : set = TRUE;          /* set clock from dos date-time */
                       break;
            case 'v' :
            case 'V' : verbose = TRUE;      /* verbose mode */
                       break;
            case 'w' :
            case 'W' : wait = TRUE;         /* wait for exact minute */
                       break;
            case '?' : exit(1);             /* unknow switch */
                       break;
        }
    }

    if (verbose) printf("AT&T 6300 Clock Set Program\n\n");

    if (set) {
        getdate(&today);
        gettime(&now);
        if (wait) {
            while (now.ti_sec) {
                gettime(&now);
            }
        }
        if (!info) {
            setctime(&now);
            setcdate(&today);
            if (verbose) {
                printf("Setting clock date to ");
                showdate(&today);
                printf("Setting clock time to ");
                showtime(&now);
            }
        } else {
            printf("Current DOS date is ");
            showdate(&today);
            printf("Current DOS time is ");
            showtime(&now);
        }
    } else {
        getcdate(&today);
        getctime(&now);
        if (wait) {
            while (now.ti_sec) {
                getctime(&now);
            }
        }
        if (!info) {
            settime(&now);
            setdate(&today);
            if (verbose) {
                printf("Setting DOS date to ");
                showdate(&today);
                printf("Setting DOS time to ");
                showtime(&now);
            }
        } else {
            printf("Current clock date is ");
            showdate(&today);
            printf("Current clock time is ");
            showtime(&now);
        }
    }
}


/*
 * help()
 *
 * list available options
 */
 void help(name)
 char *name;
 {
     printf("%s: available options are:\n", name);
     printf("\ti - information only, does not change clock or DOS date-time\n");
     printf("\th - list of options\n");
     printf("\tr - reset clock (zeros seconds and re-initializes clock)\n");
     printf("\ts - sets clock date-time from DOS date-time\n");
     printf("\tv - verbose mode, says what's going on\n");
     printf("\tw - wait until seconds = 0, so clock get sets exactly\n");
     printf("\nNote that options -i and -s may be combined to output the\n");
     printf("current DOS date and time\n");
}
