/*
  English language messages for TAD v2.00.

  To create a version for your own language, copy this file to "lang-xx.c",
  where "xx" is your language identifier. Modify the strings as necessary,
  then add the appropriate defines to "tad.c". You may also want to change
  the place_str() and approx_time() functions.
*/


// 12345678901234567890
// 23:59:59 31/12/99
#define MAX_TIME 18		// maximum length of time_fmt[1]

// 12345678901234567890123456789012345678901234567890
// 365 days, 23 hours, 59 minutes and 59 seconds
#define MAX_DUR  46		// maximum length of calibration duration

// 123456789012
// 12:00:00 am
#define MAX_CLOCK 12		// maximum length of $T


// Default time format strings. There are three versions for each of normal,
// brief and concise.

char* time_fmt[]   = { "$+2C  $D, $d $M, $Y",
		       "$+C $b",
		       "$Y$0m$0d$0H$0n$0s" };

char* approx_fmt[] = { "The time is $a.",
		       "It's $a.",
		       "$A." };

char* year_fmt[]   = { "$d $M is the $1y day of $Y.",
		       "Day $y, Year $Y.",
		       "$y" };

char* week_fmt[]   = { "It is the $1w week of $Y.",
		       "Week $w, Year $Y.",
		       "$w" };


// Months of the year (normal, abbreviated).

char* monthname[2][12] = {
  { "January",   "February", "March",    "April",
    "May",       "June",     "July",     "August",
    "September", "October",  "November", "December" },

  { "Jan", "Feb", "Mar", "Apr", "May", "Jun",
    "Jul", "Aug", "Sep", "Oct", "Nov", "Dec" }
};

// The length of the longest month (abbreviated names are assumed to be equal).
int longest_monthname = 9;


// Days of the week (normal, abbreviated).

char* dayname[2][7] = {
  { "Sunday",   "Monday", "Tuesday", "Wednesday",
    "Thursday", "Friday", "Saturday" },

  { "Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat" }
};

int longest_dayname = 9;


// Ante-meridian and post-meridian (before and after noon).
char* ampm[] = { "am", "pm" };
int   longest_ampm = 2;


// Time and date separators (read from COUNTRY info).
char time_sep = ':';
char date_sep = '/';
int  date_ord = 1;	// 0 = m/d/y, 1 = d/m/y, 2 = y/m/d
int  time_hr  = 1;	// 0 = 12-hour, 1 = 24-hour


// Strings required for the approximate time function.

char* hourname[] = { "midnight",
		     "one",  "two", "three",  "four",
		     "five", "six", "seven",  "eight",
		     "nine", "ten", "eleven",
		     "midday" };

char* fives[]	 = { "o'clock", "five", "ten", "a quarter",
		     "twenty",  "twenty-five", "half" };

char* rel[]	 = { "past", "to" };


// Exit code and brief duration characters.

// Day of week, century (19 or 20),
// years, months, weeks, days, hours, minutes, seconds.
// Order is important!
// If you change this, don't forget to change exit_help() and calc_help().
char exit_char[] = "DYyMwdhms";

// Duration words (plural and singular).
char* durname[7][2] = { { "years",   "year"   },
			{ "months",  "month"  },
			{ "weeks",   "week"   },
			{ "days",    "day"    },
			{ "hours",   "hour"   },
			{ "minutes", "minute" },
			{ "seconds", "second" } };

// Duration message when zero.
char* zero_dur[] = { "less than a second",      // Calibration message
		     "There's no time!" };      // Duration message

// Word to combine the second-last and last durations together.
char* and_str = "and";

// Thousands and decimal separators (read from COUNTRY info).
char thou_sep = ',';
char deci_sep = '.';
