	      page 60,132
	      title Hardware Timing Function MSC 3.00 & 4.00
;
YES	equ	1
NO	equ	0
;
;---------------------------------------------------------------------------
;  Memory Model selector for Microsoft C v3.0, ASM files.
;---------------------------------------------------------------------------
;  -- model --			  -- equates --
; {small}		    _LDATA = NO    _LCODE = NO
; {medium}		    _LDATA = NO    _LCODE = YES
; {compact}		    _LDATA = YES   _LCODE = NO
; {large}		    _LDATA = YES   _LCODE = YES
;---------------------------------------------------------------------------
;
;	-- Small Memory Model --
;
_LDATA	equ   NO		  ; data area size
_LCODE	equ   NO		  ; code pointers far.
;
;
include MODEL.H 		  ; get memory model header
;
;---------------------------------------------------------------------------
;  Set up the program segment for the memory model selected.
;---------------------------------------------------------------------------
;
if _LCODE
    pseg utils
else
    pseg
endif
;
;---------------------------------------------------------------------------
;
;  void tdelay( n )
;  int n;		-- Number of 1/18.2 sec intervals to delay
;
;  Provide a timed delay of the indicated number of 1/18.2 second
;  intervals.  This permits timing of all manner of things.
;
;---------------------------------------------------------------------------
;
if _LCODE
    dynx    struc
    xscx    dw	    ?	     ; tdelay data storage area
    xsdx    dw	    ?
    x_bp    dw	    ?
    xret    dd	    ?
    xarg1   dw	    ?
    dynx    ends
else
    dynx    struc
    xscx    dw	    ?
    xsdx    dw	    ?
    x_bp    dw	    ?
    xret    dw	    ?
    xarg1   dw	    ?
    dynx    ends
endif
;
	public _tdelay
;
if _LCODE
_tdelay proc	 far
else
_tdelay proc	 near
endif
	push	bp
	sub	sp,4			; local variables
	mov	bp,sp
	push	si
	push	di
	xor	ah,ah			; see what ticker says first
	int	1Ah			; CX:DX is starting point.
	mov	[bp].xsdx,dx		; save it on the stack
	mov	[bp].xscx,cx

tloop:	xor	ah,ah			; function to get tdelay
	int	1Ah			; get tdelay tiks to CX:DX
	cmp	cx,word ptr [bp].xscx	; check hi-order part
	je	tl2			; if same
;
;  Hi-order part has rolled over, so add instead of subtracting
;  the lo-order parts, with increment
;
	add	dx,[bp].xsdx
	inc	dx

tl2:	sub	dx,[bp].xsdx		; low-order part
	cmp	dx,word ptr [bp].xarg1	; is elapsed = specified ?
	jl	tloop
	add	sp,4
	pop	di
	pop	si
	pop	bp
	ret
_tdelay  endp
;
;---------------------------------------------------------------------------
;   End of program code
;---------------------------------------------------------------------------
;
if	      _LCODE
	      endps utils
else
	      endps
endif
	      end

