;  Copyright, 1988-1992, Russell Nelson, Crynwr Software
; History:210,1

;   This program is free software; you can redistribute it and/or modify
;   it under the terms of the GNU General Public License as published by
;   the Free Software Foundation, version 1.
;
;   This program is distributed in the hope that it will be useful,
;   but WITHOUT ANY WARRANTY; without even the implied warranty of
;   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;   GNU General Public License for more details.
;
;   You should have received a copy of the GNU General Public License
;   along with this program; if not, write to the Free Software
;   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

comment \

14 on 8 off 15 on 72 off
15 on 7 off 14 on 
15 on 7 off 15 on 
28 on 
36 on
36 on

\

majver		equ	1		;version number.
version		equ	0

ANSWER_NO	equ	0		;CCOM answering types.
ANSWER_FAX	equ	1
ANSWER_CAM	equ	2
ANSWER_MODEM	equ	3

HT	equ	09h
CR	equ	0dh
LF	equ	0ah

segmoffs	struc			; defines offs as 0, segm as 2
offs		dw	?
segm		dw	?
segmoffs	ends

code	segment para public
	assume	cs:code, ds:code

	org	80h
phd_dioa	label	byte

	org	100h
start:
	jmp	start_1

their_int_8	dd	?

ccom_ptr	dd	?

previous_1	db	?
previous_2	db	?
old_filtered	db	?
filtered_count	dw	?
count		dw	?

readbyte:
;enter with bx = address to read from
;exit with al = byte.
	push	dx
	pushf
	cli
	mov	dx,2e0h
	mov	al,bh			;high byte to port+1
	inc	dx
	out	dx,al
	dec	dx

	mov	al,bl			;low byte to port+0
	out	dx,al

	add	dx,4			;input from port+4.
	in	al,dx
	popf
	pop	dx
	ret

our_int_8:
	assume	ds:nothing
	pushf				;run everybody else first.
	call	their_int_8

	push	ax			;save register.
	push	bx
	push	cx
	push	dx
	push	si
	push	di
	push	ds
	push	es
	cld
	mov	ax,cs
	mov	ds,ax
	assume	ds:code
	sti

	mov	bx,7000h
	call	readbyte

	cmp	al,0c0h			;idle?
	mov	al,'1'
	jne	do_again_1		;no, ringing.
	mov	al,'0'
do_again_1:

;have to do a little filtering here.  We don't want to output bad samples,
;so we discard a sample if it disagrees with both of the previous samples.
;This is just a moving average.
	mov	ah,previous_1		;get previous sample.
	mov	previous_1,al		;remember this for later.
	cmp	al,ah			;same as last time?
	je	do_again_2		;yes, use it.
	cmp	al,previous_2		;same as the time before that?
	je	do_again_2		;yes, use it.
	mov	al,ah			;no, output previous sample.
do_again_2:
	mov	previous_2,ah		;now set older sample.

	inc	count			;count up a sample.
	cmp	al,old_filtered		;still the same?
	mov	old_filtered,al		;(remember the new one)
	je	count_same		;yes, keep incrementing the count.

;;; here's where we recognize the short rings.
	cmp	al,'0'			;transition to silence.
	jne	count_different

	mov	al,ANSWER_CAM		;answer voice on one second ring.

	cmp	count,15+2		;allow for some slop (2 18.2ths is enuf).
	ja	count_ring

	mov	al,ANSWER_FAX		;answer FAX on two short rings.

count_ring:
	les	di,ccom_ptr		;set our answering style.
	mov	es:[di+1ab8h],al
count_different:
	mov	count,0
count_same:

	pop	es
	pop	ds
	assume	ds:nothing
	pop	di
	pop	si
	pop	dx
	pop	cx
	pop	bx
	pop	ax
	iret

end_resident	label	byte

copyleft_msg	label	byte
 db "CCOM redirector version ",'0'+majver,".",'0'+version," copyright 1992, Crynwr Software",CR,LF
 db "This program is free software; see the file COPYING for details.",CR,LF
 db "NO WARRANTY; see the file COPYING for details.",CR,LF,CR,LF,'$'

noccom_msg	db	"Resident code not found",CR,LF,'$'

	align	16
fax_signature	db	"?AX ResidentCode"
fax_signature_len	equ	$ - fax_signature

error:
	mov	ah,9
	int	21h
err_quit:
	mov	al,1
        mov     ah,04ch                 ; exit with errorlevel 1
        int     21h

start_1:
	mov	dx,offset copyleft_msg
	mov	ah,9
	int	21h

	mov	si,offset fax_signature
	mov	cx,fax_signature_len
	mov	al,'F'
	call	find_signature
	mov	dx,offset noccom_msg
	je	error			;go if we found ourselves.
	mov	ccom_ptr.offs,di
	mov	ccom_ptr.segm,es

	mov	ax,3508h		;get their timer interrupt.
	int	21h
	mov	their_int_8.offs,bx
	mov	their_int_8.segm,es

	mov	ax,2508h		;set our timer interrupt.
	mov	dx,offset our_int_8
	int	21h

	mov	dx,offset end_resident
	add	dx,0fh			;round up to next highest paragraph.
	mov	cl,4
	shr	dx,cl
	mov	ax,3100h		;terminate, stay resident.
	int	21h

	include	findsig.asm

code	ends

	end	start
