
/*
	MOUSE.HPP
	Created 1994 by Dejvid Zaninovic
*/

#ifndef MOUSE_HPP
#define MOUSE_HPP

#include "c.hpp"

struct ms_button {						// which button is down
	boolean left: 1;
	boolean right: 1;
	boolean center: 1;
};

extern boolean mouse_text;				// text or graph mode
extern word mouse_buttons;				// how many buttons

extern "C" boolean mouse_init();		// resets the mouse
extern "C" void mouse_show();			// show mouse pointer
extern "C" void mouse_hide();			// hide mouse pointer
extern "C" ms_button mouse_button();	// get mouse button status (pressed)
extern "C" boolean mouse_push();		// is any button pushed
extern "C" word mouse_x();				// get x mouse position
extern "C" word mouse_y();				// get y mouse position
extern "C" void mouse_setxy (word x, word y);	// set mouse position
extern "C" void mouse_press (word button, word far *count, word far *x, word far *y);	// get press status
extern "C" void mouse_release (word button, word far *count, word far *x, word far *y);	// get release status
extern "C" void mouse_range (word x1, word y1, word x2, word y2);	// set range
extern "C" void mouse_gshape (word x, word y, word far *s[]);	// set graphics shape
extern "C" void mouse_tshape (word type, word p1, word p2);		// set text shape
extern "C" void mouse_distance (int &x, int &y);	// get distance of mouse
extern "C" void mouse_pen();					// enable lightpen emulation
extern "C" void mouse_unpen();					// disable lightpen emulation
extern "C" void mouse_setspeed (word h, word v);	// set horizontal and vertical mouse speed
extern "C" void mouse_getspeed (word *h, word *v);	// get horizontal and vertical mouse speed
extern "C" void mouse_exclude (word x1, word y1, word x2, word y2);	// exclude area
extern "C" void mouse_setdoubling (word limit);		// set speed-doubling
extern "C" word mouse_getdoubling();				// get speed-doubling
extern "C" word mouse_statsize();					// get size of mouse status area
extern "C" void mouse_getstat (char far *buf);		// get mouse status area
extern "C" void mouse_setstat (char far *buf);		// set mouse status area
extern "C" void mouse_setrate (word rate);			// set interrupt rate
extern "C" void mouse_setpage (word page);			// set video page 
extern "C" word mouse_getpage();					// get video page 
extern "C" boolean mouse_disable (void far *adr);	// disable driver
extern "C" void mouse_enable();						// enable driver
extern "C" boolean mouse_reset();					// software reset
extern "C" void mouse_getver (byte *major, byte *minor);	// get version
extern "C" byte mouse_gettype();					// get mouse type
extern "C" byte mouse_getirq();						// get mouse IRQ

#endif
