#include "microsc.h"
#include "micro.h"
#include "icon.h"
#include "dim.h"

Microscope::Microscope(char* name, rect rec)
    : Bl(rec, "", name, 12, FIXED, SHOW_BORDER,
	    SHOW_BORDER, 16, 16, 16)
    {
    rect r = textRect(Bl::w1->user_screen());
    Micro* micro = new Micro(r);
    insert(micro, 1);
    micro->set_ret(RET_OK | RET_CANCEL);

    rect ok_r = rect(62, 0, 64, 1);
    ok_r.origin.Y += 1;
    ok_r.corner.Y += 1;

    Element* ok_element = new Element(ok_r, OK_ELEMENT,
        BUTTON_BORDER, 16);

    ok_element->set_ret(1);
    add(ok_element);

    assign(micro, cancel_element, AC_CANCEL);
    assign(micro, ok_element, AC_OK);
    }
////////////////////////
void Microscope::show()
    {
// save the work area to the "copy.res" icon file
    global_i[10] = 0;  // DATA_X
    unlink("copy.res");                               // delete old
    rect r = /*screenRect*/(r_draw_size);   // ATTENTION !!!
//    r.origin -= area[STANDART_BORDER].origin;         // Change it if change
//    r.corner -= area[STANDART_BORDER].corner;         // r_draw in main file

    rect work = get_dim(FIG_RECTANGLE, MOVE,
	  r, rect(r.origin, r.origin + icon_size(1)), icon_size(1));
    global_i[10] = work.origin.X;
    global_i[11] = work.origin.Y;  // DATA_Y
    if(work.origin.X != work.corner.X)                // OK
	save_image("copy.res", work.origin, 1);
    else
	return;                                       // CANCEL
    Bl::show();
    }
//////////////////////
void Microscope::exe(int act)
    {
    global_num = 1;
    if(global_i[10] == 0)    // do not microscope
	{
	global_i[0] = 0;
	e.key = EVENT_ESC;
	e.what = KEYEVENT;
	return;
	}
    Bl::exe(act);
    global_num = 1;
    }