#ifndef __REPORT_MANAGER_H_
#define __REPORT_MANAGER_H_

#include "pxtable.h"
#include "prn_page.h"
#include "text_buf.h"
#include <stdio.h>

enum QUALITY { DRAFT, HI };
enum LABELS_FORMAT { LABELS_AS_IS, SKIP_WHITE };

class ReportManager
    {
    protected:
	PAGE_LAYOUT* page;
	KH_PXTable*  table;
	QUALITY quality;
	TextPage* textPage;
	int page_number;
	loc curr_pos;          // Page current position
	int labels_format;     // Wrap to fit more than 1 rec. side by side. Not used
	int num_of_col;
        long record_number;
    public:
	ReportManager(PAGE_LAYOUT* p, KH_PXTable* t, QUALITY q = DRAFT,
	    LABELS_FORMAT lf = LABELS_AS_IS, int noc = 1)
	    { page = p; table = t; quality = q; page_number = 1;
	      textPage = q == DRAFT ? new TextPage() : NULL;
	      curr_pos = loc(0, 0); labels_format = lf; num_of_col = noc;
              record_number = 1;
	    }
	~ReportManager() { delete textPage; }

	int buildPage(int table_beginning);
	int draw_addinfo(ADDINFO_LAYOUT* info);
	void print_page();
	void print();
	int print_add(ADD_LIST* add, loc pos);
	int print_record(int stop_printing);
	virtual int exit_func() { return 1; }

    };

#endif __REPORT_MANAGER_H_