#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include "fileutil.h"

#ifdef __MSDOS__
#include <dos.h>
#include <dir.h>
#endif

#ifdef __LINUX__
#include <errno.h>
#endif

char buffer[1024];

static int DirIndex = 0;
#define MAX_SAVE_DIRS 5
char *Dirs[MAX_SAVE_DIRS];

char *PushDir( void )
{
    if ( DirIndex == MAX_SAVE_DIRS ) return 0;
    getcwd( buffer, MAXPATH );
    Dirs[DirIndex] = new char[strlen(buffer)+1];
    strcpy( Dirs[DirIndex], buffer );
    return Dirs[DirIndex++];
}

void _pascal_ Chdir( char *path )
{
    if ( path ) {
        setdisk( toupper(path[0])-'A');
        chdir( path );
    }
}

int PopDir( char *path )
{
    if ( DirIndex ) {
        DirIndex --;
        if ( Dirs[DirIndex] ) {
            if ( path )
                strcpy( path, Dirs[DirIndex]);
            Chdir( Dirs[DirIndex] );
            delete Dirs[DirIndex];
            Dirs[DirIndex] = 0;
            return 1;
        }
    }
    return 0;
}

int _pascal_ FileExist( char *name )
{
    struct ffblk ffblk;
    if ( findfirst( name, &ffblk, 0xffff ) == 0 )
        return 1;
    else
        return 0;
}


//
// Read a file into an unsigned char _FAR_ buffer and return the pointer
// Takes the name of the file
//
char _FAR_* _pascal_ readfile(char *filenamein, int &BufSize, char _FAR_ *buf )
{
    char _FAR_ *ibuff;
	#ifdef __MSDOS__
    unsigned infilesize, nread;
    #endif

    #ifdef __LINUX__
    long infilesize;
    int nread;
    #endif
    
    FILE *fi;

	fi = fopen( filenamein,"rb+" );
    if ( !fi ) {
        fprintf(stderr, "Error opening %s.\n", filenamein);
        return 0;
    }

	fseek ( fi, 0, SEEK_END );
	infilesize = (unsigned) ftell(fi);
	fseek ( fi, 0, SEEK_SET );

    if ( !buf )
        ibuff = new char _FAR_ [infilesize];
    else {
        ibuff = buf;
        if ( BufSize < infilesize ) {
            fclose(fi);
            return 0;
        }
    }

    if ( !ibuff ) return 0;

	#ifdef __MSDOS__
    int fih = fileno( fi );
    _dos_read( fih, ibuff, infilesize, &nread );
    #endif

    #ifdef __LINUX__
    fread( (void*) ibuff, sizeof(char), infilesize, fi );
	#endif

    BufSize = (int)nread;

    fclose(fi);
    return ibuff;
}

//
// Write a char _FAR_ buffer to a file with size bytes
// Takes name of file to be written, pointer to buffer, and size of buffer
//
// returns number of bytes actually written
//
unsigned _pascal_
writefile( char *filenameout, char _FAR_ *obuff, unsigned size )
{
	#ifdef __MSDOS__
    unsigned nwrite;
    #endif
    
	FILE *fo;

    fo = fopen( filenameout,"wb+" );
	if ( !fo ) return 0;

	#ifdef __MSDOS__
	int foh = fileno( fo );
    _dos_write( foh, (void _FAR_*)obuff, size, &nwrite );
    #endif
    
    #ifdef __LINUX__
    size_t nwrite = fwrite( (const void*) obuff, sizeof(char), size, fo );
    #endif

/*	if ferror( fo ) return 0; */

	fclose(fo);
    return nwrite;
}
