#include <stdio.h>
#include "cmdline.h"
#include "umem.h"
#include "data.h"
#include "section.h"
#include "intel.h"

static long offset,base_offset;

static void putrecord(FILE *file, BYTE *data, int type, int datalen, int offset)
{
	int cs = 0,i;
	int len = datalen + 3;
	cs += type;
	cs += offset &255;
	cs += offset >>8;
	cs += len;
	fprintf(file,":%02X%04X%02X",len,offset,type);
	for (i=0; i < datalen; i++) {
		fprintf(file,"%02X",data[i]);
		cs += data[i];
	}
	cs = 256-(cs & 255);
	fprintf(file,"%02X\r\n",cs);
}

static void putdatarec(FILE *file, BYTE *data, int size, unsigned offset)
{
	putrecord(file,data,0,size,offset);
}
static void putendrec(FILE *file)
{
	fprintf(file,":00000001FF\r\n");
}
void IntelInit(char *q, FILE *file)
{
	base_offset = 0;
}
void IntelRundown(FILE *file)
{
			putendrec(file);
}
void OutputIntelHex(SECTION *q, char *overlay, FILE *file)
{
			offset = 0;
			while (q->size) {
				long size = q->size <= 32 ? q->size : 32;
				BYTE *t = PtrToEMSMem(q->buffer, offset);
				putdatarec(file,t,size,base_offset + offset);
				q->size -= size;
				offset += size;
			}
			base_offset +=offset;
}