#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#include "cmdline.h"
#include "umem.h"
#include "module.h"
#include "data.h"
#include "section.h"

extern char modname[];

LIST *sectionlist = 0;

SECTION **sectiontable;
static char SectionAttribs[] = "ACEMNPRSUWXZ";

void AddNewSection(SECTION *sect)
{
	LIST **l = &sectionlist, *new;
	while (*l) {
		l = *l;
	}
	sect->parent = sect;
	new = AllocateMemory(sizeof(LIST));
	new->link = 0;
	new->data = sect;
	*l = new;
}
void SectionDefinitions(int mode)
{
	int id;
	BYTE ch;
	char buf[MAX_NAMESIZE+1];
	uint flags=0;
	SECTION *q;
	buf[0] = 0;
	id = ReadNumber(0);
  CheckForComma(TRUE);
	while ((ch = ReadChar()) != '.') {
		char *p = strchr(SectionAttribs, ch);
		if (p) {
			flags |= 1 << ((uint)(p - SectionAttribs));
			CheckForComma(TRUE);
		}
		else
			break;
	}
	if (!(flags & SECTION_POSTPONE))
		flags |= SECTION_NOW;
	if (ch != '.'){
		putback(ch);
  	ReadString(buf,MAX_NAMESIZE+1);
		CheckForPeriod();
	}
	q = AllocateMemory(sizeof(SECTION));
	q->name = AllocateMemory(strlen(buf)+1);
	q->modname = AllocateMemory(strlen(buf)+1);
	strcpy(q->name, buf);
	strcpy(q->modname, modname);
	q->flags = flags;
	q->base = 0;
	q->size = 0;
	q->align = 0;
	q->link = 0;
	q->parent = 0;
	q->absbase = 0;
	q->abssize = 0;
	q->fixups = 0;
	q->fixupptr = &q->fixups;
	AddNewSection(q);
	sectiontable[id] = q;
}
void SectionAlignment(void)
{
	SECTION *q;
	int id;
	int align;
	id = ReadNumber(0);
	CheckForComma(TRUE);
	align = ReadNumber(0);
	CheckForPeriod();
	if ((q = sectiontable[id]) != 0)
		q->align = align;
}
void SectionSetSize(void)
{
	SECTION *q;
	int id;
	long size;
	id = ReadNumber(0);
	CheckForComma(TRUE);
	size = ReadNumber(0);
	CheckForPeriod();
	if ((q = sectiontable[id]) != 0) {
		q->buffer = AllocateEMSMemory(size,0);
		q->size = size;
	}
}
void SectionSetAddress(void)
{
	SECTION *q;
	int id;
	long base;
	id = ReadNumber(0);
	CheckForComma(TRUE);
	base = ReadNumber(0);
	CheckForPeriod();
	if ((q = sectiontable[id]) != 0)
		q->base = base;
}
void SectionTableInit(void)
{
	SECTION **p;
	int i;
	sectiontable = AllocateMemory(sizeof(SECTION *) * MAX_SECTIONS);
	p = sectiontable;
	for (i=0; i < MAX_SECTIONS; i++) {
		*p = 0;
		p++;
	}
}
void SectionTableRundown(void)
{
	LIST *l = sectionlist;
	DeallocateMemory(sectiontable);
	while (l) {
		SECTION *p = l->data;
		LIST *q = l->link;
		while (p) {
			SECTION *r = p->link;
			DeallocateMemory(p->name);
			DeallocateMemory(p->modname);
			DeallocateMemory(p);
			p = r;
		}
		DeallocateMemory(l);
		l = q;
	}
}