/*ͻ*\
   Filename:  \MEDUSA.H                         
   Name:      John Wiggins                      
   Course:    Programming II                    
   Function:  Header file for defines, structs, 
              enums, and prototypes.            
\*ͼ*/
/*********** Usefule Definitions ***************************/
#define TRUE 1
#define FALSE 0

/************** Define software struct lengths. *************/

#define TITLE_LENGTH 20         // Size of program name.
#define PUBLISHER_LENGTH 20     // Size of publisher's name.
#define PROGRAM_TYPE_LENGTH 20  // Size of program type.
#define VERSION_LENGTH 10       // Size of program version.
#define COMPUTER_TYPE_LENGTH 10 // Size of Computer type.
#define DISK_TYPE_LENGTH 12     // Size of disk type.
#define COPYRIGHT_LENGTH 5      // Size of copyright year.
#define COST_LENGTH 10		// Size of price.
/************************** Structs *********************************/
struct program_info
{
  char Title[TITLE_LENGTH], // The name of the program.
       PublisherName[PUBLISHER_LENGTH], // The company which made the program.
       ProgramType[PROGRAM_TYPE_LENGTH], // Type of program.  Ex. game
       ComputerType[COMPUTER_TYPE_LENGTH], // Computer type:  IBM or Macintosh.
       Version[VERSION_LENGTH], // Version number and or letter.
       DiskType[DISK_TYPE_LENGTH], // Format type:  disk format.
       Copyright[COPYRIGHT_LENGTH], // Copyright year.
       Cost[COST_LENGTH]; // Amount paid for program.
  program_info *prev;
  program_info *next;
};  typedef program_info* ProgramPtr; // Set up a pointer.

struct configure
{
  int ShowTitleFlag, // Title screen flag.
       JokeFlag,     // Joke flag.
       DebugFlag;    // Debug flag.
};

/* Prototypes ͸*\
   The arrangment of the prototypes doubles as a sort of calling map.  
   The prototypes are aranged in order of, well let's call it          
   "appearance."  This is not by any means to be used as a replacement 
   of the original calling map.  The actual calling map is with main   
   (main-jc.cpp file)                                                  
\*;*/

// Main \\
void InitGraphics();
int exist_file(char *file_name);
void ReadConfigFile(configure &CurConfig);
  void FileError(char Type, char *Problem);
void TitleScreen(char *program);
void LoadAll(ProgramPtr &ProgramHead); // Load data from disk.
// Show About Button \\
void About();
// Main Menu \\
void MainMenu(configure &CurConfig);
    void ViewAll(ProgramPtr AllProgram);
    void NoDataError(configure CurConfig);
    // EAR Menu \\
    void ERAMenu(ProgramPtr &ProgramHead, int &DataExists);
      void EditData(ProgramPtr &ProgramHead);
      void View2Pick(char *Function, ProgramPtr ProgramHead, ProgramPtr &PickedRecord);
      char SelectField();
      void AddData(ProgramPtr &ProgramHead);
        char MediaButtons(char *Action);
      void DelData(ProgramPtr &ProgramHead);
      void SearchRecord(ProgramPtr SearchHead);
	void Add2List(ProgramPtr CurProgram, ProgramPtr &FoundSearchHead);
    // Option Menu \\
    void OptionMenu(configure &CurConfig);
      void JokeToggle(configure &CurConfig);
      void TitleScreenToggle(configure &CurConfig);
      void DisplayConfig(configure CurConfig);
      void SaveOptions(configure CurConfig);
      void Help(char HelpCase);
    void Create(int &DataExists);
      int GetData(program_info &NewProgram, int &DataExists);
    void Remove(ProgramPtr &ProgramHead);
    void Quit(ProgramPtr ProgramHead, int &repeat);
      void SaveAll(ProgramPtr ProgramHead);
    void ReadMe();
void Ending();
void HaveNiceDay();