/* -*- Mode: C -*- */
/* LLScrollPrompt.cc - LineList version of Scroll w/prompt
 * Created by Robert Heller on Tue Mar 24 19:36:10 1992
 *
 * ------------------------------------------------------------------
 * Home Libarian by Deepwoods Software
 * Common Class library implementation code
 * ------------------------------------------------------------------
 * Modification History:
 * ------------------------------------------------------------------
 * Contents:
 * ------------------------------------------------------------------
 * 
 * 
 * Copyright (c) 1991,1992 by Robert heller (D/B/A Deepwoods Software)
 *        All Rights Reserved
 * 
 */

#ifdef MESSYDOS
#include <llscrpmt.h>
#else
#include <LLScrollPrompt.h>
#endif

struct scrollstack {
	LineList* next;
	LineList* prev;
};

const int stacksize = 20;

static scrollstack stack[stacksize];

int LLScrollPrompt::Scroll(const LineList* scrolltext,const char* prompt,char* answer,int answersize)
{
	int c = (Terminal::term->colms - strlen(Title)) >> 1;
	Terminal::term->Clear();
	Terminal::term->RevsPen();
	Terminal::term->PutStrAt(1,c,Title);
	Terminal::term->PlainPen();
	LineList* n = (LineList*) scrolltext;
	LineList* p = (LineList*) 0;
	int stackpointer = 0;
	int nchars = 0;
	while (n != 0) {
		stack[stackpointer].next = n;
		stack[stackpointer].prev = p;
		int crow;
		for (crow = 0; crow < ScrollHeight; crow++) {
			if (n == 0) break;
			Terminal::term->PutStrInBox(ScrollRow+crow,ScrollCol,
						ScrollWidth,1,n->thisline);
			p = n;
			n = n->nextline;
		}
		if (crow < ScrollHeight) 
			Terminal::term->PutStrInBox(ScrollRow+crow,ScrollCol,
						    ScrollWidth,
						    ScrollHeight-crow," ");
		nchars = Terminal::term->PromptLine(PromptRow,0,prompt,answer,answersize);
		if (nchars == 1) {
			switch (answer[0]) {
				case '+': nchars = 0; break;
				case '-':
				    if (stackpointer > 0) {
					    stackpointer--;
					    n = stack[stackpointer].next;
					    p = stack[stackpointer].prev;
					    stackpointer--;
				    }
				    nchars = 0;
				    break;
				case 'q':
				case 'Q': return(0);
			}
		}
		if (nchars != 0) return(nchars);
		stackpointer++;
	}
	//return(Terminal::term->PromptLine(PromptRow,0,prompt,answer,answersize));
	return(nchars);
}


