; Program ..: Portswap.ASM
; Author ...: Robert Boies
; Date .....: August 1, 1985
; Note .....: Swaps the LPT1 and LPT2 ports in PC/MS-DOS 2.x

;***********************************************************
CODESEG SEGMENT BYTE PUBLIC 'CODE'
	ASSUME	CS:CODESEG,DS:CODESEG
        ORG     0FA00H   ; Originate at 64000 decimal above
                        ; the top of dBASE II. 	

;----------------------------------------------------------
PORTSWAP PROC	NEAR

START:
       PUSH    DS       ; Save environment.
       PUSH    AX
       PUSH    BX
       PUSH    DI
       MOV     AX,40H   ; System stores critical operating
                        ; parameters at segment 40H (absolute
                        ; address 400H).
                        ; Load this segment address into AX.
       PUSH    AX       ; Put it on the stack.
       POP     DS       ; Pop the segment id from the
                        ; stack into extra segment register.
       MOV     DI,8H    ; Port address of LPT1 and LPT2 are
                        ; stored at offsets 8H and 0AH in
                        ; this segment.  Load DI with offset.
       MOV     AX,[DI]
                        ; Put the port address of the
                        ; first printer into the accumulator.
       INC    DI        ; Increment the destination index twice
       INC    DI        ; to point to port address of the
                        ; second printer.
       MOV    BX,[DI]
                        ; Put the port address of the second
                        ; printer into BX.
       MOV    [DI],AX
                        ; Poke the address of the first printer
                        ; into the location of the second
                        ; printer.
       DEC    DI        ; Decrement DX twice to point to the
       DEC    DI        ; port address of the second printer.
       MOV    [DI],BX
                        ; Poke the address of the second
                        ; printer
                        ; into the location of the first.

       POP    DI        ; Restore environment.
       POP    BX
       POP    AX
       POP    DS

       RET              ; Return to dBASE II.

PORTSWAP ENDP
;-------------------------------------------------------
CODESEG	ENDS
;*******************************************************
	END	START
