* Program..: Bargraph.PRG
* Author...: Brian Evans
* Date.....: August 1, 1985
* Version..: dBASE II, 2.4 and above
* Note(s)..: This program generates a bar graph of monthly
*            accounts receivable and accounts payable data for a
*            fiscal year from Accounts.DBF.  
ERASE
SET TALK OFF
* ---Create axes.
STORE CHR( 196 ) TO x
STORE CHR( 179 ) TO y
STORE 1 TO counter
* ---Generate y-axis border and labels (amounts in 100s).
DO WHILE counter <= 14
   IF INT( counter/3.0 ) = counter/3
      @ counter + 3,6 SAY STR( ( 5 - counter/3 ),1 )+"00";
                          + CHR( 180 )
   ELSE
      @ counter + 3,10 SAY y
   ENDIF
   STORE counter + 1 TO counter
ENDDO
* ---Generate x-axis border and labels (months).
@ 18,10 SAY CHR( 192 )
STORE 1 TO counter
DO WHILE counter <= 61
   STORE INT( counter/5 ) TO mthcnt
   STORE "JanFebMarAprMayJunJulAugSepOctNovDec" TO allmonth
   STORE $( allmonth, ( mthcnt - 1 ) * 3 + 1, 3 ) TO mth
   IF INT( counter/5.0 ) = counter/5
      @ 18,10 + counter SAY CHR( 194 )
      @ 19, 9 + counter SAY mth
   ELSE
      @ 18,10 + counter SAY x
   ENDIF
   STORE counter + 1 TO counter
ENDDO
USE Accounts
STORE 0 TO sumrec
STORE 0 TO sumpay
STORE 1 TO counter
DO WHILE counter <= 12
   * ---Set up simulated arrays for assigning monthly
   * ---accounts receivable (rec1-rec12), and accounts
   * ---payable (pay1-pay2).
   IF counter < 10
      STORE "rec" + STR( counter,1 ) TO rec
      STORE "pay" + STR( counter,1 ) TO pay
   ELSE
      STORE "rec" + STR( counter,2 ) TO rec
      STORE "pay" + STR( counter,2 ) TO pay
   ENDIF
   * ---Assign monthly totals to the appropriate variable.
   SUM Amount TO &rec FOR !( Accttype ) = "R" .AND. Month = counter
   SUM Amount TO &pay FOR !( Accttype ) = "P" .AND. Month = counter
   STORE counter + 1 TO counter
ENDDO
* ---Draw the bars.
STORE 1 TO counter
DO WHILE counter <= 12
   * ---Choose the correct array variable for the
   * ---monthly accounts payable and receivable.
   IF counter < 10
      STORE "rec" + STR( counter,1 ) TO rec
      STORE "pay" + STR( counter,1 ) TO pay
   ELSE
      STORE "rec" + STR( counter,2 ) TO rec
      STORE "pay" + STR( counter,2 ) TO pay
   ENDIF
   * ---Round variables to fit into screen and graph value
   * ---limitations.
   STORE INT( ( &pay/500 ) * 16 ) TO &pay
   STORE INT( ( &rec/500 ) * 16 ) TO &rec
   * ---Draw the accounts payable bar.
   STORE 1 TO upline
   DO WHILE upline <= &pay
      @ 18 - upline,10 + ( counter * 5 ) SAY CHR( 177 )
      STORE upline + 1 TO upline
   ENDDO
   * ---Draw the accounts receivable bar.
   STORE 1 TO upline
   DO WHILE upline <= &rec
      @ 18 - upline,11 + ( counter * 5 ) SAY CHR( 176 )
      STORE upline + 1 TO upline
   ENDDO
   STORE counter + 1 TO counter
ENDDO
* ---Add screen information to complete graph picture.
@ 21,31 SAY "YEARLY ACCOUNTS"
@  1,45 SAY CHR( 177 ) + " = accounts payable"
@  3,45 SAY CHR( 176 ) + " = accounts receivable"
CLEAR
* EOP Bargraph.PRG