/********************************************************************
**  YRCLJUL.C v0.17T  Copyright (c) 1987, 1988, 1989 by Paul M. Sittler.
**
**  Produces 3-digit Julian date calendars for YEARCAL.
**
**  All rights reserved.  The copyright owner hereby authorizes the
**  no-charge, noncommercial making and/or distribution of copies of
**  the entirety of this work unchanged and unincorporated in any
**  other work (except "LiBRary" or "ARChive" disk files for the sole
**  purpose of no-charge noncommercial distribution).  No other
**  reproduction or use is authorized without the express prior
**  written consent of the copyright owner.
**
**************************************************************/

/* ANSI header files included:  */
#include <stdio.h>	/* fclose, fopen, fp, fprintf, fputs, */
			/* gets, printf, rename, sprintf, stderr */
#include <stdlib.h>	/* exit */
#include <string.h>	/* strcat, strcmp, strcpy, strlen */

#include "yearcal.def"

/* External variables and structures declared in YEARCAL.C */
extern char *lingo[];			/* Names of languages array */
extern char *mnam[][12];		/* Names of months array */

extern char *new_file;
extern char *file;
extern FILE *fp;



void jul_printer(int year, char out, char base, int lang, char pause)
/* char base;	Number base used, 0 = Decimal, H = Hex, O = Octal */
/* int lang;	Language used 1=Danish, 2=Dutch, 3=English etc. */
/* char pause;	Page pause True/False */
{
    int month,
	day,
	stat,
	count,
	leep;
    char  temp[BUF];
    int jul[12][31];			/* Array for Julian yr, */
					/* 12 months/year */
					/* 31 days/month */
    char *off = (out == 'V') ?
			 " " :
		       "   "  ;
    int month_length[12] =
    {
	0,  31,  59,  90, 120, 151, 181, 212, 243, 273, 304, 334
    };

    char jul1[] =
    {"Month:   Jan  Feb  Mar  Apr  May  Jun  Jul  Aug  Sep  Oct  Nov  Dec"};

    char jul2[] =
    {"         ---  ---  ---  ---  ---  ---  ---  ---  ---  ---  ---  ---"};

    leep = leap(year);			/* Find out if leap year */
    sprintf(jul1,
    "         %3.3s  %3.3s  %3.3s  %3.3s  %3.3s  %3.3s  %3.3s  %3.3s  %3.3s  %3.3s  %3.3s  %3.3s",
	   mnam[lang - 1][0], mnam[lang - 1][ 1], mnam[lang - 1][ 2],
	   mnam[lang - 1][3], mnam[lang - 1][ 4], mnam[lang - 1][ 5],
	   mnam[lang - 1][6], mnam[lang - 1][ 7], mnam[lang - 1][ 8],
	   mnam[lang - 1][9], mnam[lang - 1][10], mnam[lang - 1][11] );

    if (out == 'F')
    {
	sprintf(file, "%dJUL%c", year, base);
	strcpy(new_file, file);
	strcat(file, ".$$$");
	sprintf(temp, ".%3.3s", lingo[lang - 1]);
	strcat(new_file, temp);
	fp = fopen(file, "w");
    }

    if (pause     &&			/* User wants time after each page */
	out == 'P' )			/* gets printed to add paper etc... */
	hold();				/* Wait for keystroke */

    fputs("\n\n\n", fp);
    sprintf(temp, "%s%s%s%s 3-Digit Julian Calendar for %d",
		 (base == 'O') ? "Olde " : "" ,
		 base ? "Hacker's " : "" ,
		 base ? ( (base == 'O') ? "Octal " : "Hexadecimal ") : "",
		 lingo[lang - 1],
		 year);
    fputs(center(temp, (out == 'V') ? 75 : 89), fp);
    fputs("\n\n\n", fp);
    fprintf(fp, "%s%s\n", off, jul1);
    fprintf(fp, "%s%s\n", off, jul2);

    for (month = 0;
	 month < 12;			/* 12 months */
	 month++)
	for (day = 1;
	     day < 32;			/* 31 days possible */
	     day++)
	{
	    count = (day + month_length[month] + ((month > 1) ? leep : 0) );
	    if (count > (month_length[month + 1] + ((month) ? leep : 0)) )
		count = 0;
	    jul[month][day - 1] = count;
	}

    for (day = 0;
	 day < 31;
	 day++)
    {
	if ( (day)       &&
	     (!(day % 2)) )
		fprintf(fp, "\n");

	fprintf(fp, "%sDay #%2d", off, day + 1);

	for (month = 0;
	     month < 12;
	     month++)
	{
	    if (jul[month][day])
	    {
		fprintf(fp,
		   (base ?
		       ((base == 'O') ?
			      "  %3o" :
			      "  %3X" ) :
			      "  %3d"    ),
			  jul[month][day]);
	    }
	    else
		fprintf(fp, "     ");
	}
	fprintf(fp, "   Day #%2d\n", day + 1);
    }

    if (out != 'V')
	fputs("\f\r", fp);		/* No FF for screen */

    if (out == 'F')			/* Setup for file output */
	if ((stat = fclose(fp)) == ERROR)
	    printf("\nCan't close %s.\n", file);

    if (out == 'F')
	if ((stat = rename(file, new_file)) == ERROR)
	    printf(
	    "\nCan't rename %s to %s.  %s may already exist.\n",
			    file, new_file,
				       new_file);
}



