/****************************************************************
*
*  Name:          POINT
*
*  Function:      track the pointer as it passes through the window.
*
*  Shows how to:  1. create and read a pointer object.
*                 2. force the keyboard mouse ON, if applicable.
*                 3. display single characters in a window.
*                 4. jump the pointer.
*                 5. change cursor position for a window.
*
****************************************************************/

#include <stdio.h>
#include "dvapi.h"

/* minimum API version required */
#define required 0x201

/* actual API version number */
int    version;

/* object handles */
ulong  win,ptr;

/* variables used to read pointer messages */

int     mlng;
struct {int  row;
        int  col;
        char button;
        char field;
       } *mptr;

/* startup message */
char   msg1[] = "\
This program will display a \"0\" wherever you\n\
move the mouse and a \"1\" wherever you click\n\
button 1.  Button 2 exits the program.\n";


/**********************************************************************
*  main  -  check for DESQview present and enable required extensions.
***********************************************************************/

main () {
  /* initialize C interfaces and get API version number */
  version = api_init();

  /* if DESQview is not running or version is too low, display a message */ 
  if (version < required) {
    printf ("This program requires DESQview version %d.02%d or later.\n",
             required/256,required%256);
    }

  /* tell DESQview what extensions to enable and start application */
  else {
    api_level (required);
    program_body();
    }

  /* disable C interfaces and return from program */
  api_exit();
  }


/**********************************************************************
*  program_body  -  display a "0" wherever the pointer moves and a
*                   "1" wherever button 1 is clicked.
***********************************************************************/

program_body () {
  /* find window handle and create a pointer object */
  win = win_me();
  ptr = ptr_new();

  /* erase the window and display startup message */
  win_erase (win);
  win_swrite (win,msg1);

  /* open the pointer object, force keyboard mouse ON, and position pointer */
  ptr_open (ptr,win);
  api_kmouse (1);
  ptr_write (ptr,4,20);

  /* loop until button 2 is clicked */
  do {

    /* read a pointer message and extract button number */
    ptr_read (ptr,&mptr,&mlng);

    /* move cursor to pointer position and display button # or 0 */
    win_cursor (win,mptr->row,mptr->col);
    win_putc (win,'0'+(mptr->button),7);
    } 
    while ((mptr->button) != 2);

  /* free pointer object and return */
  ptr_free (ptr);
  }































