;************************************************************************
;*									*
;*	DV-GLUE		DESQview and DESQview/X Function Library	*
;*			(c) Copyright 1992 Ralf Brown			*
;*			All Rights Reserved.				*
;*									*
;*	File DVSTREAM.INC	Stream-related definitions      	*
;*									*
;************************************************************************
;LastEdit: 12/19/92

;/*==========================================*/
;/* stream headers, place at beginning of a  */
;/* stream                                   */
;/*==========================================*/

S_WINDOW	MACRO	name
name	db  1Bh, 00h
	dw  name&_len-4
		ENDM

S_QUERY		MACRO	name
name    db  1Bh, 01h
	dw  name&_len-4
		ENDM

S_MANAGER	MACRO	name
name	db  1Bh, 10h
	dw  name&_len-4
		ENDM

S_END		MACRO	name
name&_len equ ($-name)
		ENDM

;/*==========================================*/

WS_BLANKS	MACRO	num
	db 00h + (num and 1Fh)
		ENDM

WS_CHAR		MACRO	num,ch
	db 20h + (num and 1Fh),ch
		ENDM

WS_ATTR	MACRO	num,attr
	db 40h + (num and 1Fh),attr
		ENDM

WS_CHARS	MACRO	chars
		LOCAL	start,len
	db 60h + len
start	db chars
IF ($-start) gt 32
	.err "String too long in WS_CHARS"
ELSEIF ($-start) eq 32
	len equ 0
ELSE
	len equ $-start
ENDIF
		ENDM

WS_MANYBLANKS	MACRO	num
	db 80h + ((num shr 8) and 7),(num and 0FFh)
		ENDM

WS_MANYCHAR	MACRO	num,ch
	db 88h + ((num shr 8) and 7),(num and 0FFh)
	db ch
		ENDM

WS_MANYATTR	MACRO	num,attr
	db 90h + ((num shr 8) and 7),(num and 0FFh)
	db attr
		ENDM

WS_MANYCHARS	MACRO	num
	db 98h + ((num shr 8) and 7),(num and 0FFh) ; + chars
		ENDM

WS_SETCURSROW	MACRO	row
	db 0A0h,row
		ENDM

WS_SETCURSCOL	MACRO	col
	db 0A1h,col
		ENDM

WS_SCRLROW	MACRO	row
	db 0A2h,row
		ENDM

WS_SCRLCOL	MACRO	col
	db 0A3h,col
		ENDM

WS_WINROW	MACRO	row
	db 0A4h,row
		ENDM

WS_WINCOL	MACRO	col
	db 0A5h,col
		ENDM

WS_WINROWS	MACRO	rows
	db 0A6h,rows
		ENDM

WS_WINCOLS	MACRO	cols
	db 0A7h,cols
		ENDM

WS_VIEWPORTROW	MACRO	row
	db 0A8h,row
		ENDM

WS_VIEWPORTCOL	MACRO	col
	db 0A9h,col
		ENDM

WS_LSIZEROWS	MACRO	rows
	db 0AAh,rows
		ENDM

WS_LSIZECOLS	MACRO	cols
	db 0ABh,cols
		ENDM

WS_CURSDOWN	MACRO	rows
	db 0B0h,rows
		ENDM

WS_CURSRIGHT	MACRO	cols
	db 0B1h,cols
		ENDM

WS_SCRLORIGDOWN	MACRO	rows
	db 0B2h,rows
		ENDM

WS_SCRLORIGRIGHT	MACRO	cols
	db 0B3h,cols
		ENDM

WS_SHFTWINROW	MACRO	rows
	db 0B4h,rows
		ENDM

WS_SHFTWINCOL	MACRO	cols
	db 0B5h,cols
		ENDM

WS_EXPWINROWS	MACRO	rows
	db 0B6h,rows
		ENDM

WS_EXPWINCOLS	MACRO	cols
	db 0B7h,cols
		ENDM

WS_SHFTVIEWROW	MACRO	rows
	db 0B8h,rows
		ENDM

WS_SHFTVIEWCOL	MACRO	cols
	db 0B9h,cols
		ENDM

WS_RELSIZEROWS	MACRO	rows
	db 0BAh,rows
		ENDM

WS_RELSIZECOLS	MACRO	cols
	db 0BBh,cols
		ENDM

WS_CURSPOS	MACRO	row,col
	db 0C0h,row,col
		ENDM

WS_SCRLORIG	MACRO	row,col
	db 0C1h,row,col
		ENDM

WS_WINPOS	MACRO	row,col
	db 0C2h,row,col
		ENDM

WS_WINSIZE	MACRO	rows,cols
	db 0C3h,rows,cols
		ENDM

WS_VIEWPORT	MACRO	row,col
	db 0C4h,row,col
		ENDM

WS_LSIZE	MACRO	rows,cols
	db 0C5h,rows,cols
		ENDM

WS_RELCURS	MACRO	rows,cols
	db 0C8h,rows,cols
		ENDM

WS_RELSCRL	MACRO	rows,cols
	db 0C9h,rows,cols
		ENDM

WS_RELWINPOS	MACRO	rows,cols
	db 0CAh,rows,cols
		ENDM

WS_RELWINSIZ	MACRO	rows,cols
	db 0CBh,rows,cols
		ENDM

WS_RELVIEWP	MACRO	rows,cols
	db 0CCh,rows,cols
		ENDM

WS_RELLSIZE	MACRO	rows,cols
	db 0CDh,rows,cols
		ENDM

WS_SCROLLTEXT	MACRO
	db 0CEh
		ENDM

WS_SCROLLATTR	MACRO
	db 0CFh
		ENDM

WS_PARTFRAME	MACRO
	db 0D0h		; allow partial frame if window beyond edge of screen
		ENDM

WS_FULLFRAME	MACRO
	db 0D1h		; force full frame when window extends beyond screen
		ENDM

WS_AUTOCOLOR	MACRO
	db 0D2h		; DV will change logical attributes on mode switch
		ENDM

WS_PROGCOLOR	MACRO
	db 0D3h		; program changes its own logical attributes
		ENDM

WS_UPDATE	MACRO
	db 0D4h,0E4h
		ENDM

WS_UNHIDDEN	MACRO
	db 0D4h
		ENDM

WS_HIDDEN	MACRO
	db 0D5h
		ENDM

WS_FRAME	MACRO
	db 0D6h
		ENDM

WS_NOFRAME      MACRO
	db 0D7h
		ENDM

WS_READCHAR	MACRO
	db 0D8h
		ENDM

WS_READATTR	MACRO
	db 0D9h
		ENDM

WS_LOGATTR	MACRO
	db 0DAh
		ENDM

WS_PHYSATTR	MACRO
	db 0DBh
		ENDM

WS_CTRLCHAR	MACRO
	db 0DCh
		ENDM

WS_NOCTRLCHAR	MACRO
	db 0DDh
		ENDM

WS_WRITEATTR	MACRO
	db 0DEh
		ENDM

WS_LEAVEATTR	MACRO
	db 0DFh
		ENDM

WS_REPEAT	MACRO	count
	db 0E0h,count
		ENDM

WS_DOREPEAT	MACRO
	db 0E1h
		ENDM

WS_SETCOLOR	MACRO	color
	db 0E2h,color
		ENDM

WS_CLEAR	MACRO
	db 0E3h
		ENDM

WS_REDRAW	MACRO
	db 0E4h
		ENDM

WS_TWOKEY_MENU	MACRO
	db 0E5h,018h
		ENDM

WS_NEWWIN	MACRO	rows,cols
	db 0E6h,rows,cols
		ENDM

WS_SCRL_UP	MACRO	h,w
	db 0E8h,h,w
		ENDM

WS_SCRL_DOWN	MACRO	h,w
	db 0E9h,h,w
		ENDM

WS_SCRL_LEFT	MACRO	h,w
	db 0EAh,h,w
		ENDM

WS_SCRL_RIGHT	MACRO	h,w
	db 0EBh,h,w
		ENDM

;/* each of the next three opcodes must be followed by the proper number of */
;/* data bytes */
WS_ATTRIB	MACRO	flags,f,start,num
	db 0ECh,flags,(f shl 7) + ((start and 7) shl 4) + (num and 15)
		ENDM

WS_FRATTR	MACRO	flags,f,start,num
	db 0EDh,flags,(f shl 7) + ((start and 7) shl 4) + (num and 15)
		ENDM

WS_FRCHAR	MACRO	flags,f,start,num
	db 0EEh,flags,(f shl 7) + ((start and 7) shl 4) + (num and 15)
		ENDM

WS_TITLE	MACRO	title
		LOCAL start,len
	db 0EFh
	db len
start	db title
len equ ($-start)
		ENDM

WS_FLDCLEAR	MACRO	fld
	db 0F0h,fld
		ENDM

WS_FLDCHAR	MACRO	fld,char
	db 0F1h,fld,char
		ENDM

WS_FLDATTR	MACRO	fld,color
	db 0F2h,fld,color
		ENDM

WS_FLDCURS	MACRO	fld
	db 0F4h,fld
		ENDM

WS_FLDTYPE	MACRO	fld,type
	db 0F6h,fld,type
		ENDM

WS_FLDSCRLUP	MACRO	fld
	db 0F8h,fld
		ENDM

WS_FLDSCRLDOWN	MACRO	fld
	db 0F9h,fld
		ENDM

WS_FLDSCRLLEFT	MACRO	fld
	db 0FAh,fld
		ENDM

WS_FLDSCRLRIGHT	MACRO	fld
	db 0FBh,fld
		ENDM

WS_FLDUNMODIFY	MACRO
	db 0FDh
		ENDM

WS_FLDRESET	MACRO
	db 0FEh
		ENDM

;/* to define a field table, use WS_FLDTABLE followed by the appropriate number */
;/* of WS_FLD_DEF */
WS_FLDTABLE	MACRO	flds,type,curcol,selcol
	db 0E5h,018h,0FFh,flds,type,0,0,curcol,selcol
		ENDM


WS_FLD_DEF	MACRO	urow,ucol,lrow,lcol,type,mod,col,mod2
        db urow,ucol,lrow,lcol,type,mod,col,mod2
		ENDM


;/*==========================================*/

QS_CURSROW	MACRO
	db 0A0h,0
		ENDM

QS_CURSCOL	MACRO
	db 0A1h,0
		ENDM

QS_SCRLROW	MACRO
	db 0A2h,0
		ENDM

QS_SCRLCOL	MACRO
	db 0A3h,0
		ENDM

QS_WINROW	MACRO
	db 0A4h,0
		ENDM

QS_WINCOL	MACRO
	db 0A5h,0
		ENDM

QS_WINROWS	MACRO
	db 0A6h,0
		ENDM

QS_WINCOLS	MACRO
	db 0A7h,0
		ENDM

QS_VIEWROW	MACRO
	db 0A8h,0
		ENDM

QS_VIEWCOL	MACRO
	db 0A9h,0
		ENDM

QS_LSIZEROWS	MACRO
	db 0AAh,0
		ENDM

QS_LSIZECOLS	MACRO
	db 0ABh,0
		ENDM

QS_CURSPOS	MACRO
	db 0C0h,0,0
		ENDM

QS_SCRLORIG	MACRO
	db 0C1h,0,0
		ENDM

QS_WINPOS	MACRO
	db 0C2h,0,0
		ENDM

QS_WINSIZE	MACRO
	db 0C3h,0,0
		ENDM

QS_VIEWPORT	MACRO
	db 0C4h,0,0
		ENDM

QS_LOGSIZE	MACRO
	db 0C5h,0,0
		ENDM

QS_SCROLLATTR	MACRO
	db 0CFh
		ENDM

QS_FULLFRAME	MACRO
	db 0D1h
		ENDM

QS_PROGCOLOR	MACRO
	db 0D3h
		ENDM

QS_HIDDEN	MACRO
	db 0D5h
		ENDM

QS_FRAME	MACRO
	db 0D6h
		ENDM

QS_READATTR	MACRO
	db 0D9h
		ENDM

QS_LOGATTR	MACRO
	db 0DAh
		ENDM

QS_CTRLCHAR	MACRO
	db 0DCh
		ENDM

QS_LEAVEATTR	MACRO
	db 0DFh
		ENDM

QS_COLOR	MACRO
	db 0E2h,0
		ENDM

QS_FLDTYPE	MACRO
	db 0F6h,0
		ENDM

;/*==========================================*/
;/* OR in these when building manager stream */
;/* which uses the immediately following     */
;/* manifest constants                       */
;/* *don't* OR in when calling DVwin_allow,  */
;/* DVwin_disallow, DVwin_notify, or         */
;/* DVwin_cancel                             */
;/*==========================================*/

MS_ALLOW          equ  00h
MS_DISALLOW       equ  20h
MS_NOTIFY         equ  40h
MS_NONOTIFY       equ  60h

DV_HMOVE          equ  00h ;/* origin of window moves l/r */
DV_VMOVE          equ  01h ;/* origin of window moves u/d */
DV_HSIZE          equ  02h ;/* window width changes */
DV_VSIZE          equ  03h ;/* window height changes */
DV_HSCROLL        equ  04h ;/* window scrolled l/r */
DV_VSCROLL        equ  05h ;/* window scrolled u/d */
DV_CLOSE          equ  06h ;/* "Close" menu option */
DV_HIDE           equ  07h ;/* window hidden */
DV_MARK           equ  08h ;/* "Mark" menu, allow/disallow only */
DV_HELP           equ  08h ;/* "?" main menu selection, notify/cancel only */
DV_COLORS         equ  09h ;/* "Rearrange" "Colors"???  notify/cancel only */
DV_SWITCHEDTO     equ  0Ah ;/* switched from another window to this one, notify/cancel only */
DV_RAISE          equ  DV_SWITCHEDTO
DV_SWITCHEDAWAY   equ  0Bh ;/* switched to another window, notify/cancel only */
DV_LOWER          equ  DV_SWITCHEDAWAY
DV_VIDEOMODE      equ  0Ch ;/* changing video mode, notify/cancel only */
DV_SCISSORS_CUT   equ  0Dh ;/* selected "Scissors" "Cut", notify/cancel only */
DV_SCISSORS_COPY  equ  0Eh ;/* selected "Scissors" "Copy" */
DV_SCISSORS       equ  0Eh ;/* allow/disallow "Scissors" menu */
DV_SCISSORS_PASTE equ  0Fh ;/* "Scissors" "Paste" selected, notify/cancel only */
DV_MAINMENU       equ  10h ;/* DV menu popped up */
DV_SWITCH         equ  11h ;/* "Switch" menu, allow/disallow only */
DV_MENU_END       equ  11h ;/* DV menu popped down, notify/cancel only */
DV_OPENMENU       equ  12h ;/* "Open" menu, allow/disallow only */
DV_QUIT           equ  13h ;/* "Quit" selection, allow/disallow only */

;/*==========================================*/

MS_ATTACH	MACRO
	db 084h
		ENDM

MS_DETACH	MACRO
	db 085h
		ENDM

MS_FOREONLY	MACRO
	db 086h
		ENDM

MS_NOFOREONLY	MACRO
	db 087h
		ENDM

MS_MINSIZE	MACRO	rows,cols
	db 88h,rows,cols
		ENDM

MS_MAXSIZE	MACRO	rows,cols
	db 89h,rows,cols
		ENDM

MS_PRIM_ASYNC	MACRO	seg,addr
	db 08Ah
	dw addr,seg
		ENDM

MS_SEC_ASYNC	MACRO	seg,addr
	db 08Bh
	dw addr,seg
		ENDM

MS_REGSELECT	MACRO
	db 0ACh		; perform regular select field processing
		ENDM

MS_PROTSELECT	MACRO
	db 0ADh		; perform protected attribute select field processing
		ENDM

MS_DFLTNOTIFY	MACRO
	db 0AEh		; make window default notification window
		ENDM

MS_FLDMARKER	MACRO	ch
	db 0AFh,ch   ;/* marker character for selected fields */
		ENDM

MS_STDFIELDPROC MACRO
	db 0BCh		; select standard field processing mode
		ENDM

MS_MENUCURSOR	MACRO
	db 0BDh		;/* enable cursor keys on menus */
		ENDM	; (alternate field processing mode)
MS_ALTFIELDPROC equ MS_MENUCURSOR

MS_NOREVATTR	MACRO
	db 0BEh		; disable changing of reverse logical attributes
		ENDM

MS_ALLOWREVATTR	MACRO
	db 0BFh		; allow changing of reverse logical attributes
		ENDM

MS_WINTOPSYS	MACRO
	db 0C0h  ;/* make window topmost in system */
		ENDM

MS_GOFORE	MACRO
	db 0C1h  ;/* put task in foreground */
		ENDM

MS_WINTOP	MACRO
	db 0C2h  ;/* make window topmost in process */
		ENDM

MS_CURRFLDPOS	MACRO	row,col
	db 0C3h,row,col  ;/* move mouse pointer rel to cur fld */
		ENDM

MS_FLDPOS	MACRO	fld,row,col
	db 0C4h,fld,row,col  ;/* move ptr rel to given fld */
		ENDM

MS_ORPHAN	MACRO
	db 0C5h
		ENDM

MS_WINSHOW	MACRO
	db 0C6h
		ENDM

MS_HIDE 	MACRO
	db 0C7h
		ENDM

MS_SUSPEND	MACRO
	db 0C8h
		ENDM

MS_GOBACK	MACRO
	db 0C9h
		ENDM

MS_WINBOTTOM	MACRO
	db 0CAh
		ENDM

MS_CANCEL	MACRO
	db 0CBh
		ENDM

MS_PASTE	MACRO
	db 0CCh
		ENDM

MS_REORDER	MACRO seg,off
	db 0CEh
	dw off,seg
		ENDM

MS_NOP		MACRO
	db 0FFh
		ENDM

;/*=====================================================================*/
;/* header for a panel file */

PAN_HEADER	MACRO	num_panels
	db 0C0h,0C3h,num_panels
		ENDM


;/* end of file DVSTREAM.INC */
