;************************************************************************
;*									*
;*	DV-GLUE		DESQview and DESQview/X Function Library	*
;*			(c) Copyright 1992 Ralf Brown			*
;*			All Rights Reserved.				*
;*									*
;*	File WININFO.ASM	Return information about a window	*
;*									*
;************************************************************************
;LastEdit: 3/28/93

	INCLUDE	API.INC
	INCLUDE DVSTREAM.INC
	MIN_VERSION 2,00

	Header@

;========================================================================

OBJ_OWNER equ 10h
OBJ_MAPCONTEXT equ 12h
OBJ_TSKFLAG equ 14h
OBJ_PROCNUM equ 15h
OBJ_FOREFLAGS equ 0B3h
OBJ_TSKSTATUS equ 0B6h

;========================================================================

wininfo_buffer STRUC
wb_taskflag	db ?			; task flag
wb_procnum	db ?			; process number
wb_owner	dw ?			; segment of owner's handle
wb_mapcontext	dw ?			; mapping context
wb_status	db ?			; status
		db ?			; unused
wb_flags	dw ?			; flag bits
wb_fgonly	db ?			; foreground-only
wininfo_buffer ENDS

;========================================================================

DSeg@
ExtSym@ _dvversion,WORD,__CDECL__

S_QUERY		info_stream
	QS_LOGSIZE
	QS_WINSIZE
	QS_WINPOS
	S_END	info_stream
DSegEnd@

;========================================================================

CSeg@

PubProc@ DVWIN_INFO,__PASCAL__
@win = dword ptr [bp+SendOverhead+dPtrSize]
@info = DPTR_ [bp+SendOverhead]
	ASSUME	ES:NOTHING
	@EnterSend
	cmp	_dvversion@,0232h	; DV 2.50+ ?
	jb	old_wininfo
	sub	sp,size wininfo_buffer	; reserve space for wininfo buffer
	mov	ax,112Ch		; WININFO call
	mov	bx,word ptr @win+2	; segment of window handle
	mov	dx,0100h		; info format version 1.00
	push	ss
	pop	es
	ASSUME	ES:NOTHING
	mov	di,sp			; ES:DI -> buffer for window info
	int	15h
	LES_	di,@info
	mov	bx,sp			; SS:BX -> wininfo buffer
	stosw				; AX = 0, becomes offset of owner handle
	mov	ax,SS_[bx].wb_owner
	stosw				; set segment of owner handle
	mov	ax,SS_[bx].wb_mapcontext
	stosw				; set mapping context
	mov	ax,SS_[bx].wb_flags
	stosw				; set flag bits
	mov	ax,word ptr SS_[bx].wb_taskflag
	stosw				; set task flag & process number
	mov	al,SS_[bx].wb_status
	mov	ah,SS_[bx].wb_fgonly
	stosw				; set task status & fgonly
	jmp short got_wininfo

old_wininfo:
	push	ds			; remember DS
	LES_	di,@info
IF LDATA eq 0
	push	ds
	pop	es
ENDIF
	lds	si,@win			; point at object record
	ASSUME	DS:NOTHING
	xor	ax,ax
	stosw				; set offset of owner handle
	mov	ax,[si].OBJ_OWNER
	stosw				; set segment of owner handle
	mov	ax,[si].OBJ_MAPCONTEXT
	stosw				; set mapping context
	mov	ax,0FFFFh		; flags unavailable
	stosw				; set flag bits
	mov	al,[si].OBJ_TSKFLAG
	mov	ah,[si].OBJ_PROCNUM
	dec	ah			; change to zero-based process number
	stosw				; set task flag & process number
	mov	al,[si].OBJ_TSKSTATUS
	mov	ah,[si].OBJ_FOREFLAGS
	and	ah,1			; only use low bit, "foreground only"
	stosw				; set task status and fgonly
	pop	ds			; restore DS
	ASSUME	DS:DGROUP
got_wininfo:
	STACK_STREAM DGROUP:info_stream
	pushm	es,di			; remember destination buffer
	push	bx			; remember address of copied stream
	WIN_STREAM @win,ss,bx
	pop	bx			; retrieve address of stream
	popm	di,es			; retrieve address of data buffer
	mov	ax,SS_[bx+5]
	stosw				; set logrows & logcols
	mov	ax,SS_[bx+8]
	stosw				; set physrows & physcols
	mov	ax,SS_[bx+11]
	stosw				; set posrow & poscol
wininfo_done:
	@ExitSend 4+dPtrSize
EndProc@ DVWIN_INFO,__PASCAL__

CSegEnd@

	END
