/*
 * The macro EXTRACT_PROGRAM_NAME(p) converts an MSDOS style argument 0
 * full path program name to a nice, Un*x style argument 0 program name.
 */
#include <string.h>
#define EXTRACT_PROGRAM_NAME(p)		\
    {					\
    	char	*q;			\
	if (q = strrchr(p, '\\'))	\
	    p = q + 1;			\
	if (q = strchr(p, '.'))		\
	    *q = '\0';			\
	strlwr(p);			\
    }



/*
 * The macro CONVERT_TO_SLASHES(p) converts all backslashes in a pathname
 * to forward slashes.  As a nice extra effect, it converts upper case to
 * lower case.
 */
#define CONVERT_TO_SLASHES(p)		\
    {					\
	char	*q;			\
	for (q = p; *q; ++q)		\
	    if (*q == '\\')		\
		*q = '/';		\
	strlwr(p);			\
    }
