; :ts=8
; Set/get the option separator character via the undocumented DOS call 0x37.
; Call from c:
;	char switchar(char switch);
; If switch is greater than a space, it is set to the current switch character.
; In any case, the function returns the current/new switch character.
; Compile with NODOS3 true to generate code to disable this code on DOS 3.0
; and higher and always return "/".

; (c) 1988 Otto Makela, Jyvaskyla, Finland
	include	lmacros.h
	procdef	switchar,<<switch,byte>>

	ifdef	NODOS3
	mov	ah,030h		; Retrieve DOS version
	int	021h
	cmp	al,3		; Less than 3.0 ?
	mov	al,'/'		; Simulate switchar
	jae	skip2		; Less, skip
	endif

	mov	dl,switch	; Load switch character
	cmp	dl,' '		; Less or equal to space ?
	jbe	skip1		; Yes, can't be switchar

	mov	ax,03701h	; Subfunction one = set switchar
	int	021h

skip1:	mov	ax,03700h	; Subfunction zero = get switchar
	int	021h
	mov	al,dl		; Load return value
skip2:	pret
	pend	switchar
	finish
	end
