; routines to handle hardware errors.

; hardset installs a hardware error routine and sets the global
; variable _Hard_error to FALSE (0)

; hardclear deinstalls the hardware error routine

; hardhandle receives control if an error occurs.  It sets _Hard_error
; to 1 + error code and tells MS-DOS 2 to ignore the error, MS-DOS 3+ to
; fail the DOS call.

TRUE	equ	1
FALSE	equ	0

	DGROUP	GROUP _DATA,_BSS

_BSS	segment word public 'bss'
_BSS	ends

_DATA	segment word public 'data'
old24	dd	?		; save old int 24 address here
_DATA	ends

	extrn	_Hard_error:word
	extrn	_Fail_ignore:word
	public	_hardset,_hardclear

_TEXT	SEGMENT BYTE PUBLIC 'CODE'
	ASSUME	CS:_TEXT,DS:DGROUP

_hardset proc	far

	mov	DGROUP:_Hard_error,FALSE	; set no error

	mov	ax,3524h		; get interrupt vector
	int	21h
	mov	word ptr old24,bx	; old vector is in ES:BX
	mov	word ptr old24+2,es
	mov	ax,2524h		; set interrupt vector
	mov	dx,offset hardhandle
	push	ds
	push	cs
	pop	ds
	int	21h
	pop	ds

	ret
_hardset endp

_hardclear proc far

	mov	ax,2524h		; set interrupt vector
	push	ds
	lds	dx,old24		; restore old vector
	int	21h
	pop	ds

	ret
_hardclear endp

hardhandle proc	far

	push	ds
	mov	ax,SEG DGROUP
	mov	ds,ax
	and	di,7fh			; error code in low byte
	inc	di			; return 1+error so non-zero if error
	mov	DGROUP:_Hard_error,di
	mov	ax,DGROUP:_Fail_ignore	; 0 for DOS-2 (ignore), else 3 (fail)
	pop	ds
	iret

hardhandle endp

_TEXT	ends
	end
