/*************************************************************
 *                                                           *
 * Program DCOPY - physical sector to sector copy     	     *
 * Copyright (c) 1986 Joerg Genius, Munich, West-Germany     *
 *                                                           *
 * Rev. 3.1.1 fixed verify by supplying length to memcpy()   *
 * Rev. 3.1.2 added /r command to verify only                *
 *************************************************************/

#include <stdio.h>
#include <alloc.h>
#include <sys\types.h>
#include <sys\stat.h>
#include <io.h>
#include "dcdefs.h"


dfsource (f_name,von,nach,verify,nocompress)

int nach,verify,nocompress;
FILE *von;
char *f_name;


{
   unsigned char *ver_buffer;     	 /* one sector for verify */
   struct drive_data dest;
   unsigned int blcnt;
   int error;
   unsigned int subcnt;
   unsigned char *freesec; /* SECTOR BITMAP */
   unsigned char *freewhat;
   unsigned int sec_maps;
   unsigned int max_blocks;
   int file_type;


   if (verify!=0) {
      if ((ver_buffer=malloc(512*blk_p_buffer))==NULL) {
         fprintf (stderr,text[2]);
         return (1);
      }
   }
   if (get_drive_data(nach,&dest)!=0)
      return (1);
   if (nocompress==0 && blk_p_buffer>64)
      blk_p_buffer=64;
   max_blocks=get_max_blocks(dest.sec_p_drive);
   if (nocompress) {
      if ((int)(filelength(fileno(von))/512)!=dest.sec_p_drive) {
         fprintf (stderr,text[20]);
         return (1);
      }
   }
   else {
      if ((freesec=malloc((dest.sec_p_drive+7)/8))==NULL ||
          (freewhat=malloc(dest.sec_p_drive))==NULL) {
          fprintf (stderr,text[2]);
         return (1);
      }
      sec_maps=(dest.sec_p_drive+7)/8;
      if (fread(&file_type,2,1,von)!=1) {
         fprintf (stderr,text[21]);
         return (1);
      }
      if (file_type!=dest.sec_p_drive) {
         fprintf (stderr,text[20]);
         return (1);
      }
   }
   printf (text[8],d_types[disk_type]);
   if (verify!=2)
      printf (text[22],dest.sec_p_drive,f_name,nach+'A');
   else
      printf (text[24],dest.sec_p_drive,f_name,nach+'A');
   if (nocompress) {
      for (blcnt=0;blcnt<dest.sec_p_drive;blcnt+=max_blocks) {
         max_blocks=(blcnt+max_blocks>=dest.sec_p_drive ? dest.sec_p_drive-blcnt : max_blocks);
         if (fread(disk_buffer,512,max_blocks,von)!=max_blocks) {
            fprintf (stderr,text[21]);
            return (1);
         }
         if (verify!=2) {
            if ((error=write_block(nach,blcnt,max_blocks,disk_buffer))!=0) {
               fprintf (stderr,text[16],error,err_text[error]);
               return (1);
            }
         }
         if (verify!=0) {
            if ((error=read_block(nach,blcnt,max_blocks,ver_buffer))!=0) {
               fprintf (stderr,text[17],error,err_text[error]);
               return (1);
            }
            if (memcmp(disk_buffer,ver_buffer,512*max_blocks)!=0) {
               fprintf (stderr,text[18]);
               return (1);
            }
         }
      }
      if (verify!=2)
         printf (text[23],dest.sec_p_drive,f_name,nach+'A');
      else
         printf (text[25],dest.sec_p_drive,f_name,nach+'A');
      return (0);
   }
   if (fread(freesec,1,sec_maps,von)!=sec_maps) {
      fprintf (stderr,text[21]);
      return (1);
   }
   if (fread(freewhat,1,dest.sec_p_drive,von)!=dest.sec_p_drive) {
      fprintf (stderr,text[21]);
      return (1);
   }
   for (blcnt=0;blcnt<dest.sec_p_drive;blcnt+=max_blocks) {
      max_blocks=(blcnt+max_blocks>=dest.sec_p_drive ? dest.sec_p_drive-blcnt : max_blocks);
      for (subcnt=0;subcnt<max_blocks;subcnt++) {
         if ((freesec[(blcnt+subcnt)/8] & (1<<((blcnt+subcnt)%8)))!=0) {
            memset(&disk_buffer[512*subcnt],freewhat[blcnt+subcnt],512);
	 }
	 else {
            if (fread(&disk_buffer[512*subcnt],1,512,von)!=512) {
               printf (text[21]);
               return(0);
            }
	 }
      }
      if (verify!=2) {
         if ((error=write_block(nach,blcnt,max_blocks,disk_buffer))!=0) {
            fprintf (stderr,text[16],error,err_text[error]);
            return (1);
         }
      }
      if (verify!=0) {
         if ((error=read_block(nach,blcnt,max_blocks,ver_buffer))!=0) {
            fprintf (stderr,text[17],error,err_text[error]);
            return (1);
         }
         if (memcmp(disk_buffer,ver_buffer,512*max_blocks)!=0) {
            fprintf (stderr,text[18]);
            return (1);
         }
      }
   }
      if (verify!=2)
         printf (text[23],dest.sec_p_drive,f_name,nach+'A');
      else
         printf (text[25],dest.sec_p_drive,f_name,nach+'A');
   return (0);
}
   
