/*
 *  DRSP - DriveSpeed, version 3.10 (GPL FREEWARE)
 *  Copyleft (l) Stanislav Sokolov, May 1998 and onwards.
 *
 *  This program is subject to GNU General Public License ver. 2 of June 1991
 *  and any later version.
 *
 *  You may use this source with your programs, provided
 *  due credits are given.
 *
 *  Contact the author by e-mail: stanislavs@hotmail.com
 *
 *  Internet:  http://members.tripod.com/~stanislavs/prog/prog.htm
 */

#include "D:\TC\MY\DRSP\DRSP.H"
#include "D:\TC\UTILS\USER\USER.H"

//Analyze a RW process
void Analyze(TestData TD, float WriteSpd, float ReadSpd, float FAS){
	FILE *Handle;
	GetTxt *Txt = new GetTxt;  //A class from my user library
	char FName[MAX_PATH];
	char Append, Comment[70] = {'\0'};
	struct time curTime;
	struct date curDate;
	float WriteKB, WriteMB, ReadKB, ReadMB;

	signal(SIGFPE, Trap);    //Install floating point error handler

	WriteKB = (TD.TestSize * 1024.0) / WriteSpd;
	WriteMB = TD.TestSize / (WriteSpd / 60.0);

	ReadKB = (TD.TestSize * 1024.0) / ReadSpd;
	ReadMB = TD.TestSize / (ReadSpd / 60.0);

	if(fError) Abort(0, NULL, "Overflow in a variable.", EX_MATH_ERR);
	if(Txt == NULL) Abort(0, NULL, "Out of memory in Analyze()", EX_NO_MEM);

	gettime(&curTime);
	getdate(&curDate);

	printf(DBL_LINE);
	printf("Drive:\t\t\t\t  %c:\n", TD.Drive);

	printf("Test size in MB:\t\t%#6.2f\n", TD.TestSize);
	printf("Number of turns:\t\t%3i\n\n", TD.Turns);

	printf("Average write speed in KB/Sec:\t%#20.12f\n", WriteKB);
	printf("Average write speed in MB/Min:\t%#20.12f\n\n", WriteMB);

	printf("Average read speed in KB/Sec:\t%#20.12f\n", ReadKB);
	printf("Average read speed in MB/Min:\t%#20.12f\n\n", ReadMB);

	printf("FAS in operations/Sec:\t\t  %#9.3f", FAS);
	printf(DBL_LINE);

	//Open the log-file
	if((Handle = OpenLog(TD, FName)) == NULL)
		Abort(0, NULL, "Error opening log-file.", EX_NO_LOG);

	//Suppress any user interaction in batch mode and log the results
	if(!TD.Batch){
		printf("\nDo you want to append these results to an ASCII log-file\n"
			   "%s? (Y/N) ", strupr(FName));

		Append = Ask("");
	}else{
		Append = 'Y';
	}

	if(Append == 'Y' || Append == 13){
		if(!TD.Batch){
			printf("\n\nPlease enter your optional comments to this test on the line below.\n"
				   "Comments: ");

			Txt->InText(Comment, 69, wherey(), wherex(), 69);
		}

		printf("\n%s\n%s\n", L1, L2);
		printf(DISK_STAT, TD.Drive, TD.TestSize, TD.Turns, WriteKB, WriteMB, ReadKB, ReadMB);
		printf("%s\n", L3);
		printf(FAS_STAT, curDate.da_day, curDate.da_mon, curDate.da_year, curTime.ti_hour, curTime.ti_min, FAS);
		printf("%s\n", L4);

		fprintf(Handle, "\n%s%s\n", "Comments: ", Comment);
		fprintf(Handle, "%s\n%s\n", L1, L2);
		fprintf(Handle, DISK_STAT, TD.Drive, TD.TestSize, TD.Turns, WriteKB, WriteMB, ReadKB, ReadMB);
		fprintf(Handle, "%s\n", L3);
		fprintf(Handle, FAS_STAT, curDate.da_day, curDate.da_mon, curDate.da_year, curTime.ti_hour, curTime.ti_min, FAS);
		fprintf(Handle, "%s\n", L4);
	}

	if(fclose(Handle) == EOF)
		Abort(0, NULL, "Error closing log-file.", EX_NO_LOG);

	delete Txt;
	printf("\n\n");
}


//Analyze a RO process
void Analyze(TestData TD, float ReadSpd){
	FILE *Handle;
	GetTxt *Txt = new GetTxt;  //A class from my user library
	char FName[MAX_PATH];
	char Append, Comment[70] = {'\0'};
	struct time curTime;
	struct date curDate;
	float ReadKB, ReadMB;

	signal(SIGFPE, Trap);    //Install floating point error handler

	//TestSize is in megabytes
	ReadKB = (TD.TestSize * 1024.0) / ReadSpd;
	ReadMB = TD.TestSize / (ReadSpd / 60.0);

	if(fError) Abort(0, NULL, "\nOverflow in a variable.", EX_MATH_ERR);
	if(Txt == NULL) Abort(0, NULL, "Out of memory in Analyze()", EX_NO_MEM);



	gettime(&curTime);
	getdate(&curDate);

	printf(DBL_LINE);
	printf("Drive:\t\t\t\t  %c:\n", TD.Drive);

	printf("Test size in MB:\t\t%#6.2f\n", TD.TestSize);
	printf("Number of turns:\t\t%3i\n\n", TD.Turns);

	printf("Average read speed in KB/Sec:\t%#20.12f\n", ReadKB);
	printf("Average read speed in MB/Min:\t%#20.12f", ReadMB);

	printf(DBL_LINE);

	//Open the log-file
	if((Handle = OpenLog(TD, FName)) == NULL)
		Abort(0, NULL, "Error opening log-file.", EX_NO_LOG);

	//Suppress any user interaction in batch mode and log the results
	if(!TD.Batch){
		printf("\nDo you want to append these results to an ASCII log-file\n"
			   "%s? (Y/N) ", strupr(FName));

		Append = Ask("");
	}else{
		Append = 'Y';
	}

	if(Append == 'Y' || Append == 13){
		if(!TD.Batch){
			printf("\n\nPlease enter your optional comments to this test on the line below.\n"
				   "Comments: ");

			Txt->InText(Comment, 69, wherey(), wherex(), 69);
		}

		printf("\n%s\n%s\n", L1, L2);
		printf(DISK_STAT, TD.Drive, TD.TestSize, TD.Turns, 0.0, 0.0, ReadKB, ReadMB);
		printf("%s\n", L3);
		printf(NO_FAS, curDate.da_day, curDate.da_mon, curDate.da_year, curTime.ti_hour, curTime.ti_min);
		printf("%s\n", L4);

		fprintf(Handle, "\n%s%s\n", "Comments: ", Comment);
		fprintf(Handle, "%s\n%s\n", L1, L2);
		fprintf(Handle, DISK_STAT, TD.Drive, TD.TestSize, TD.Turns, 0.0, 0.0, ReadKB, ReadMB);
		fprintf(Handle, "%s\n", L3);
		fprintf(Handle, NO_FAS, curDate.da_day, curDate.da_mon, curDate.da_year, curTime.ti_hour, curTime.ti_min);
		fprintf(Handle, "%s\n", L4);
	}

	if(fclose(Handle) == EOF)
		Abort(0, NULL, "Error closing log-file.", EX_NO_LOG);

	delete Txt;
	printf("\n\n");
}


FILE *OpenLog(TestData TD, char *FName){
	FILE *Handle;
	char Path[MAX_PATH];

	//Initialize and extract program's start-up path
	for(int i=0; i<=79; i++)
		Path[i] = '\0';

	FindPath(Path);

	//Make log-file path and name
	if(TD.LogFile == NULL){  //Use default
		strcpy(FName, Path);
		strcat(FName, "DRSP.LOG");
	}else{					 //User wants another file!
		strcpy(FName, TD.LogFile);
	}

	//Attempt opening the file
	Handle = fopen(FName, "at");
	if(Handle == NULL){ //Something is wrong
		if(TD.LogFile != NULL){  //Try default - perhaps user gave wrong filename!
			strcpy(FName, Path);
			strcat(FName, "DRSP.LOG");
			Handle = fopen(FName, "at");
		}
	}

	return Handle;
}