/*
    Filename: C:\DAVE\CPP\IO\filepath.hpp
    Author  : Dave Nelson
    Created : Fri 04-Dec-1998 19:01:09
    Modified: Mon 22-Mar-1999 19:26:00 - Dave Nelson
*/

#ifndef filepath_hpp
    #define filepath_hpp



class filepath {
    char *w, d, *p, b[9], e[5];
public:
    filepath(char *fn=NULL);    // fully qualified name, or portion thereof
    filepath(filepath&);
    ~filepath();

// Methods to extract information:
    char drive();               // A, B, C, etc.
    char *base();               // filename
    char *path();               // \path
    char *namext();             // filename.ext
    char *full();               // d:\path\filename.ext
    char *location();           // d:\path
    char *ext();                // .ext

// Methods to change information:
    char setdrive(char *);      // set drive to A, B, C, etc.
    char setdrive(char);        //  "    "
    char *setbase(char *);      // set base name
    char *setext(char *);       // set extension
    char *setpath(char *);      // set path
    filepath& operator=(char *);
    filepath& operator=(filepath&);
    };



inline char * filepath::base(){     return b;   }
inline char * filepath::path(){     return p? p:"\0";   }
inline char * filepath::ext(){      return e;   }
inline char filepath::setdrive(char *dr){
    return (d = (dr? *dr:'\0'));
    }
inline char filepath::setdrive(char dr){
    return (d = dr);
    }


#endif  // filepath_hpp
