 ' Findit10 is v1.1 of a findfile function for QB v4.5 which
 ' emulates a DIR$ function similar to the DIR$ function of BC7.

 DECLARE FUNCTION DIR$ (FileSpec$)

 ' get include files.
 REM $INCLUDE: 'dta.bi'
 REM $INCLUDE: 'qb.bi'

 ' prompt for filespec.
 PRINT "Enter filespec:";
 LINE INPUT f$

 ' start filefind.
 x$ = DIR$(f$)
 DO
    ' compare result.
    IF x$ = "" THEN
       EXIT DO
    END IF

    ' display file.
    PRINT x$

    ' continue filefind.
    x$ = DIR$("")
 LOOP
 END

FUNCTION DIR$ (FileSpec$) STATIC
 ' first call to function with a filespec starts filelist match,
 ' second and following calls to function with Null string return remaining
 '   filelist matches until DIR$ returns a Null value.
 DIM InregsX AS RegTypeX
 DIM OutregsX AS RegTypeX
 DIM DTAfile AS DTAtype
 DIM ASCIIZ AS STRING * 64
 DIM Current.DTA.SEG AS INTEGER
 DIM Current.DTA.OFF AS INTEGER

 IF FileSpec$ = "" THEN
    GOSUB FindNext
 ELSE
    ASCIIZ = UCASE$(FileSpec$) + CHR$(0)
    GOSUB FindFirst
 END IF
 DIR$ = Filename$
 EXIT FUNCTION

' initate findfile.
FindFirst:

 ' store current dta
 InregsX.AX = &H2F00
 CALL InterruptX(&H21, InregsX, OutregsX)
 Current.DTA.SEG = OutregsX.ES
 Current.DTA.OFF = OutregsX.BX

 ' store function dta
 InregsX.AX = &H1A00
 InregsX.DS = VARSEG(DTAfile)
 InregsX.DX = VARPTR(DTAfile)
 CALL InterruptX(&H21, InregsX, OutregsX)

 ' findfirst
 InregsX.AX = &H4E00
 InregsX.CX = &H27
 InregsX.DS = VARSEG(ASCIIZ)
 InregsX.DX = VARPTR(ASCIIZ)
 CALL InterruptX(&H21, InregsX, OutregsX)

 ' check carry flag error
 IF (OutregsX.flags AND &H1) = &H0 THEN
    Filename$ = DTAfile.ASCIIZfilename
    Filename$ = LEFT$(Filename$, INSTR(Filename$, CHR$(0)) - 1)
 ELSE
    Filename$ = ""
 END IF

 ' restore current dta
 InregsX.AX = &H1A00
 InregsX.DS = Current.DTA.SEG
 InregsX.DX = Current.DTA.OFF
 CALL InterruptX(&H21, InregsX, OutregsX)

 RETURN

' continue filespec match.
FindNext:

 ' store current dta
 InregsX.AX = &H2F00
 CALL InterruptX(&H21, InregsX, OutregsX)
 Current.DTA.SEG = OutregsX.ES
 Current.DTA.OFF = OutregsX.BX

 ' store function dta
 InregsX.AX = &H1A00
 InregsX.DS = VARSEG(DTAfile)
 InregsX.DX = VARPTR(DTAfile)
 CALL InterruptX(&H21, InregsX, OutregsX)

 ' find next filename
 InregsX.AX = &H4F00
 CALL InterruptX(&H21, InregsX, OutregsX)

 ' check carry flag error
 IF (OutregsX.flags AND &H1) = &H0 THEN
    Filename$ = DTAfile.ASCIIZfilename
    Filename$ = LEFT$(Filename$, INSTR(Filename$, CHR$(0)) - 1)
 ELSE
    Filename$ = ""
 END IF

 ' restore current dta
 InregsX.AX = &H1A00
 InregsX.DS = Current.DTA.SEG
 InregsX.DX = Current.DTA.OFF
 CALL InterruptX(&H21, InregsX, OutregsX)

 RETURN

END FUNCTION

