REM: Include file for Hex Editor v3.5a PD 2003.

' initialize all default variables as integer.
DEFINT A-Z

' load all arrays during runtime.
REM $DYNAMIC

' get include files.
REM $INCLUDE: 'dta.bi'
REM $INCLUDE: 'qbx.bi'
REM $INCLUDE: 'wdta.bi'

' declare windows filename structure.
TYPE WinFileType
 Name AS STRING*260
END TYPE

' declare dos filename structure.
TYPE DosFileType
 Name AS STRING*12
END TYPE

' declare undo arrays.
COMMON SHARED UndoByte() AS INTEGER, UndoPosition() AS DOUBLE

' declare undo variables.
COMMON SHARED MaxUndos AS DOUBLE, CurrentUndo AS DOUBLE

' declare marker array.
COMMON SHARED Markers() AS DOUBLE

' declare marker variables.
COMMON SHARED CurrentMarker AS DOUBLE, NewMarker AS DOUBLE
COMMON SHARED MaxMarkers AS DOUBLE, MarkerCount AS DOUBLE

' declare menu area storage arrays.
COMMON SHARED Area1() AS INTEGER, Area2() AS INTEGER

' declare ascii character variables.
COMMON SHARED Hline AS INTEGER, Vline AS INTEGER
COMMON SHARED ULcorner AS INTEGER, URcorner AS INTEGER
COMMON SHARED LLcorner AS INTEGER, LRcorner AS INTEGER

' declare temporary file position variables.
COMMON SHARED Low AS DOUBLE, High AS DOUBLE, HeapSortOff AS INTEGER
COMMON SHARED TempPosition AS DOUBLE, TempPosition1 AS DOUBLE
COMMON SHARED TempPosition2 AS DOUBLE, TempPosition3 AS DOUBLE
COMMON SHARED FileDisplay AS INTEGER, FileDisplay2 AS INTEGER

' declare common program variables.
COMMON SHARED AsciiValue AS INTEGER, AsciiValue2 AS INTEGER
COMMON SHARED ASCIIValue3 AS DOUBLE, HexValue AS DOUBLE
COMMON SHARED CurrentWindow AS INTEGER, CurrentWindow2 AS INTEGER
COMMON SHARED PageColumn AS DOUBLE, PageRow AS DOUBLE
COMMON SHARED ScreenDrawn AS INTEGER, ScreenRow AS INTEGER
COMMON SHARED StatusMessage AS STRING, SupportedCall AS INTEGER

' declare filename/file position variables.
COMMON SHARED Column AS DOUBLE, Column2 AS DOUBLE
COMMON SHARED DumpFile AS STRING, Filename AS STRING
COMMON SHARED FileByte AS STRING*1, FileBytePosition AS DOUBLE
COMMON SHARED FileLength AS DOUBLE, FilePage AS DOUBLE
COMMON SHARED FilePosition AS DOUBLE, FilePosition2 AS DOUBLE
COMMON SHARED FirstByte AS DOUBLE, FilePage2 AS DOUBLE
COMMON SHARED LastByte AS DOUBLE, LastPage AS DOUBLE
COMMON SHARED NewByte AS DOUBLE, NextByte AS DOUBLE
COMMON SHARED NextLine AS DOUBLE, NextPage AS DOUBLE
COMMON SHARED NewPosition AS DOUBLE, NewPosition2 AS DOUBLE
COMMON SHARED PageColumn2 AS DOUBLE, PageRow2 AS DOUBLE
COMMON SHARED SeekPosition AS DOUBLE, SeekPosition2 AS DOUBLE
COMMON SHARED ShortFilename AS STRING, StorePosition AS DOUBLE

' declare all long filename common variables.
COMMON SHARED ASCIIZ AS STRING*261, ASCIIZ2 AS STRING*261
COMMON SHARED Buffer AS STRING*1, ConfigFile AS STRING
COMMON SHARED BASIC.DTA.OFF AS INTEGER, BASIC.DTA.SEG AS INTEGER
COMMON SHARED DTAfile AS DTAtype, ErrorTrap AS INTEGER, FileSize AS DOUBLE
COMMON SHARED FileAttribute AS INTEGER, Quote AS STRING, Handle AS INTEGER
COMMON SHARED Windows.Detected AS INTEGER, Wfile.Handle AS INTEGER
COMMON SHARED WDTAfile AS WDTAtype

' declare all common mouse variables.
COMMON SHARED Mouse.Present AS INTEGER, Mouse.Button1 AS INTEGER
COMMON SHARED Mouse.Button2 AS INTEGER, Mouse.Button3 AS INTEGER
COMMON SHARED Mouse.Row AS INTEGER, Mouse.Column AS INTEGER
COMMON SHARED Old.Mouse.Row AS INTEGER, Old.Mouse.Column AS INTEGER
COMMON SHARED Mouse.X AS INTEGER, Mouse.Y AS INTEGER

' declare filename variables for menu.bas
COMMON SHARED Attribute AS INTEGER, ASCIIZ3 AS STRING*261
COMMON SHARED Num.Dirs AS INTEGER, Num.Files AS INTEGER

' declare structures for menu.bas
COMMON SHARED WinFileStruc AS WinFileType, DosFileStruc AS DosFileType

' declare menu screen location offsets for menu.bas
COMMON SHARED Xcoor AS INTEGER, Ycoor AS INTEGER

' declare menu variables for DropDownMenu
COMMON SHARED CurrentMenu AS INTEGER, CurrentMenuSelection AS INTEGER

' declare variables for copy/paste
COMMON SHARED CopyPositionStart AS DOUBLE, CopyPositionEnd AS DOUBLE
COMMON SHARED CopyFile AS STRING, UndoFile AS STRING, CopyByte AS STRING*1

' declare interrupt structures.
COMMON SHARED InregsX AS RegTypeX, OutregsX AS RegTypeX

' declare author constants.
CONST Author="Erik Jon Oredson AS. CSci"
CONST Email="eoredson@yahoo.com"
CONST Urls="www.simtel.net www.filegate.net www.winsite.com"

' declare constants.
CONST Nul=""
CONST False=0
CONST True=-1
CONST Version="v3.5a"
CONST Release="r1.0a"
CONST Publish="04/01/2003."
CONST Status="Public Domain"
CONST Program="Hex Editor"

' declare colors.
CONST Black=0
CONST Blue=1
CONST Cyan=11
CONST Green=10
CONST Magenta=13
CONST Plain=7
CONST Red=12
CONST White=15
CONST Yellow=14

' declare bit constants.
CONST ReadOnlyBit=1
CONST HiddenBit=2
CONST SystemBit=4
CONST ArchiveBit=32

' declare mouse function constants.
CONST CheckMouse=0
CONST ShowMouse=1
CONST HideMouse=2
CONST Position=3
CONST Button=5

' declare functions.
DECLARE FUNCTION Conanicalize$(V$)
DECLARE FUNCTION ReleaseTime()
DECLARE FUNCTION TestFile(V$)
DECLARE FUNCTION TrimSpaces$(V$)

' declare record structure functions.
DECLARE FUNCTION Directories$(V%)
DECLARE FUNCTION Filenames$(V%)

' declare subroutines.
Declare Sub OpenCopyFiles()
Declare Sub DisplayBootUsage()
Declare Sub DisplayScreen()
Declare Sub DisplayScreen2()
Declare Sub DropDownMenu()
Declare Sub HelpScreen()
Declare Sub MouseDriver()
Declare Sub MouseFunction(V1%,V2%)
Declare Sub Menu(V1$,V2$,V3$,V4$)
Declare Sub ReadConfigFile(V$)
