/* 
 *  copy-filename:  Copies the filename surrounding point to a new kill
 *  buffer.  Useful if immediately followed by find-file or find-file-other-
 *  window.  Note that the filename pattern includes characters you might not 
 *  expect, such as parenthesis.  These are legal in DOS filenames.
 *
 *  Given to all Epsilon users by David S. Bakin.  Do with these what you
 *  will, but don't blame me if anything goes wrong.  
 *  March 8, 1990.
*/

#include "include\eel.h"

/* Full file pattern (nearly useless because of parenthesis):
char file_pattern[80] = "([a-zA-Z]:)*(%^|[---!@#$%&(){}~`a-zA-Z0-9_/\\.])+";
*/
/* Almost all files, but no ^ or (): */
char file_pattern[60] = "([a-zA-Z]:)*[---!@#$%&{}~`a-zA-Z0-9_/\\.]+";


/* adapted from (tags.e)pluck_tag: */
command copy_filename()
{
	int here;
	iter = 0;
	here = point--;
	re_search(1, file_pattern);
	re_search(-1, file_pattern);
	prev_cmd = 0;
	do_save_only(point, matchstart);	/* kill.e */
	this_cmd = 0;
	point = here;
}
