/*
 * For some reason I have not figured out, TurboC v2.0 dup() and dup2() functions
 * will not let me save and reassign stdin, needed for the write pipe, but they
 * will work ok for the read pipe. (freopen works on stdin, but I cannot restore
 * it without dup2())
 * Here are very simple versions that do the direct DOS calls and seem to work
 *		R. Brittain (Tested with DOS 4.0, and SHARE installed)
 */
#include <dos.h>
#include <errno.h>

dup ( int fd )
{
/*
 * Call DOS function to create a new file handle as a duplicate of
 * existing handle fd
 */
	union REGS regs;
	regs.h.ah = 0x45;
	regs.x.bx = fd;
	intdos(&regs,&regs);
	if (regs.x.cflag) {
		errno = regs.x.ax;
		return(-1);
	} else {
		return(regs.x.ax);
	}
}

dup2 (int ofd, int nfd )
{
/*
 * Call DOS function to duplicate handle nfd onto existing handle ofd
 */
	union REGS regs;
	regs.h.ah = 0x46;
	regs.x.bx = nfd;
	regs.x.cx = ofd;
	intdos(&regs,&regs);
	if (regs.x.cflag) {
		errno = regs.x.ax;
		return(-1);
	} else {
		return(0);
	}
}
