/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.InstallerFrame;
import com.izforge.izpack.installer.IzPanel;
import com.izforge.izpack.installer.VariableSubstitutor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.HashMap;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class XInfoPanel
extends IzPanel {
    private GridBagLayout layout = new GridBagLayout();
    private GridBagConstraints gbConstraints = new GridBagConstraints();
    private JLabel infoLabel;
    private JTextArea textArea;
    private JScrollPane scroller;
    private String info;

    private void loadInfo() {
        try {
            int n;
            InputStream inputStream = this.parent.getResource("XInfoPanel.info");
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray = new byte[5120];
            while ((n = inputStream.read(byArray)) != -1) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            this.info = byteArrayOutputStream.toString();
        }
        catch (Exception exception) {
            this.info = "Error : could not load the info text !";
        }
    }

    private void parseText() {
        try {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("INSTALL_PATH", this.idata.installPath);
            hashMap.put("JAVA_HOME", System.getProperty("java.home"));
            hashMap.put("USER_HOME", System.getProperty("user.home"));
            hashMap.put("USER_NAME", System.getProperty("user.name"));
            VariableSubstitutor variableSubstitutor = new VariableSubstitutor(hashMap);
            this.info = variableSubstitutor.substitute(this.info, null);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void panelActivate() {
        this.loadInfo();
        this.parseText();
        this.textArea.setText(this.info.toString());
        this.textArea.setCaretPosition(0);
    }

    public boolean isValidated() {
        return true;
    }

    public XInfoPanel(InstallerFrame installerFrame, InstallData installData) {
        super(installerFrame, installData);
        this.setLayout(this.layout);
        this.loadInfo();
        this.infoLabel = new JLabel(installerFrame.langpack.getString("InfoPanel.info"), installerFrame.icons.getImageIcon("edit"), 11);
        installerFrame.buildConstraints(this.gbConstraints, 0, 0, 1, 1, 1.0, 0.0);
        this.gbConstraints.insets = new Insets(5, 5, 5, 5);
        this.gbConstraints.fill = 0;
        this.gbConstraints.anchor = 16;
        this.layout.addLayoutComponent(this.infoLabel, this.gbConstraints);
        this.add(this.infoLabel);
        this.textArea = new JTextArea(this.info);
        this.textArea.setCaretPosition(0);
        this.textArea.setEditable(false);
        this.scroller = new JScrollPane(this.textArea);
        installerFrame.buildConstraints(this.gbConstraints, 0, 1, 1, 1, 1.0, 0.9);
        this.gbConstraints.fill = 1;
        this.gbConstraints.anchor = 10;
        this.layout.addLayoutComponent(this.scroller, this.gbConstraints);
        this.add(this.scroller);
    }
}

