/*
 *      S T R I N G S . C
 *
 *      This program is used to display strings in binary files
 *
 *	Steve Sampson (75136,626), Public Domain (p) November 1987
 *
 * 	Updated 12/29/87 - Pete Lyall (76703,4230)
 *
 *	- bug fix: in_string was previously never reset to FALSE,
 *	  resulting in erroneous marking of string start.
 *
 *	- hex offset of each string start is now provided to ease
 *	  hacking/patching of files.
 *
 *	Define MSDOS for that type machine, defaults to OS9
 */

#include <stdio.h>
#include <ctype.h>

#ifdef MSDOS
#include <fcntl.h>
#define	READ	O_RDONLY
#else
#include <lowio.h>
#endif

#define FALSE   0
#define TRUE    ~FALSE
#define DEFCHARS 3
#define MAXLINE 256


main(argc, argv)
int     argc;
char    *argv[];
{
     int     i, ercode, lptr, nchars = DEFCHARS, fd, in_string;
     char    *fname, inbuff[MAXLINE], outbuff[MAXLINE];
#ifndef MSDOS
     long    sofar = 0L, sstart;

     pflinit();
#endif

     if (argc < 2 || argc > 3)  
     {
          fprintf(stderr, "Usage: strings [n] <filename>\n");
          fprintf(stderr, "Where n is the minimum width (default is 3)\n");
          exit(0);
     }

     if (argc == 3)  
     {
          nchars = abs(atoi(argv[1]));
          if (nchars < 1 || nchars > MAXLINE - 1)  
          {
               fprintf(stderr, "strings: Maximum width is %d\n", MAXLINE - 1);
               exit(1);
          }

          fname  = argv[2];
     }
     else
          fname  = argv[1];


     if ((fd = open(fname, READ)) == -1)  
     {
          fprintf(stderr, "strings: File `%s' Not Found\n", fname);
          exit(1);
     }

     lptr = 0;                               /* Index into outbuff        */
     in_string = FALSE;                      /* Not in a string yet       */

     while ((ercode = read(fd, inbuff, MAXLINE)) > 0)  
     {
          for (i = 0; i < ercode; i++)  
          {

               /* Search entire buffer */

               if (in_string && isprint(inbuff[i]))

                    /* We are in a string and are continuing */

                    outbuff[lptr++] = inbuff[i];

               else 
                    if (isprint(inbuff[i]))   /* would this char start one ? */
                    {
                         outbuff[lptr++] = inbuff[i]; /* start new one */
                         in_string = TRUE;      /* We're in a string now */
#ifndef MSDOS
                         sstart = i+sofar;      /* mark string start */
#endif
                    }
                    else 
                         if (in_string) /* if in one, would this end it? */
                         {
                              /* End of string */
                              if (lptr >= nchars)  /* enough to tell about? */
                              {
                                   /* Found a long-enough string */
                                   outbuff[lptr] = '\0';

                                   /* Terminate the string and print */

#ifdef MSDOS
				   printf("%s\n", outbuff);
#else
                                   printf("%6lx: %s\n", sstart, outbuff);
#endif
                              }

                              in_string = FALSE; /* PWL */
                              lptr = 0;       /* Start at beginning again */
                         }

          }

#ifndef MSDOS
          sofar += (long)ercode;   /* update how far we've read into buffers */
#endif
     }

     close(fd);
}
