/*	world - reformat world.dat data for GRAPH   */

#include <stdio.h>

typedef struct
	{char	code[2];	/* "LS" for first point in each curve, "S " otherwise */
	int		longi;
	int		lati;
	}	LLREC;

LLREC ll, saved;

FILE *ifile;
int n=1, count=0;

main(argc, argv) int argc; char **argv;
{	int prev;
	if(argc>1 && *argv[1]=='?')
		{puts("world - read WORLD.DAT and generate GRAPH input file\n");
		puts("usage:  world [n] >outfile\n");
		puts("approximately every nth point will be included \
(default: all 7574 points)\n");
		exit();
		}
	if(argc>1 && isdigit(*argv[1])) n=atoi(argv[1]);
	ifile=fopen("world.dat", "r");
	if(!ifile) {fprintf(stderr, "cannot open world.dat"); exit(1);}
	if(n>1)
		printf("; world map, including approximately 1/%d of WORLD.DAT  ", n);
	else
		printf("; world map, including all of WORLD.DAT  ", n);
	while(fread(&ll, sizeof(ll), 1, ifile))
		{count++;
		if(ll.code[0]=='L' || abs(ll.longi-prev)>15000) 
			{if(count!=1)	/* display last point in previous segment */
				printf("\n%7.2f %7.2f", saved.longi*.01, saved.lati*.01);
			puts(" \"\"\n");
			}
		else if(count<n) 
			{saved=ll;
			continue;    /* display every nth point */
			}
		else puts("\n");
		count=0;
		prev=ll.longi;
		printf("%7.2f %7.2f", ll.longi*.01, ll.lati*.01);
		}
	puts(" \"\"\n");
}

	
