unit multikbd;


interface


  uses crt,
       dos;


  var key      : array [0 .. 127] of boolean;
      last_key : byte;


  procedure init_kbd;
  (* initializes keyboard tables and keyboard interrupt procedure *)

  procedure reset_kbd;
  (* resets normal keyboard interrupt *)


implementation


const kbd_inited : boolean = false;


var old_9 : pointer;
    value : byte;


procedure reset_kbd;
(* restores normal keyboard interrupt routine call *)
begin
  if kbd_inited then begin
    kbd_inited := false;
    setintvec (9, old_9);
  end;
end;


(*$F+*)
procedure game_kbd_int; interrupt;
(* new interrupt handling routine *)
(*$F-*)
begin
  last_key := port [$60];
  if last_key = 1 then reset_kbd; (* ESC ends emulation *)
  value      := port [$61];
  port [$61] := value or 128;
  port [$61] := value;
  port [$20] := $20;
  if (last_key and 128) = 0
    then key [last_key        ] := true
    else key [last_key and 127] := false;
end;


procedure init_kbd;
(* initializes keyboard tables and keyboard interrupt procedure *)
var i : integer;
begin
  if not kbd_inited then begin
    kbd_inited := true;
    getintvec (9, old_9);
    setintvec (9, addr (game_kbd_int));
    last_key := 0;
    for i := 0 to 127 do key [i] := false;
  end;
end;


begin
end.