/************************************************************************
** MODULE INFORMATION*
**********************
**     FILE     NAME:       snmp.c
**     SYSTEM   NAME:       BEHOLDER
**     ORIGINAL AUTHOR(S):  Dirk Wisse
**     VERSION  NUMBER:     1.0
**     CREATION DATE:       1990/11/21
**
** DESCRIPTION: 
**              
*************************************************************************
** CHANGES INFORMATION **
*************************
** REVISION:    $Revision:   1.5  $
** WORKFILE:    $Workfile:   SNMP.C  $
** LOGINFO:     $Log:   I:/ETSTJAN/CPROG/BEHOLDER/APS/SNMP/VCS/SNMP.C_V  $
**              
**                 Rev 1.5   20 Mar 1991 13:35:32   etstjan
**              new version
**              
**                 Rev 1.4   20 Mar 1991 13:22:38   etstjan
**              new version
**              
**                 Rev 1.3   20 Mar 1991 12:44:04   etstjan
**              new version
**              
**                 Rev 1.2   20 Mar 1991 12:39:50   etstjan
**              new version
**              
**                 Rev 1.1   20 Mar 1991 12:15:58   etstjan
**              new version
**              
**                 Rev 1.0   01 Feb 1991 16:37:22   etstjan
**              tNo explicit note
*************************************************************************/
#if ! defined(PRD)
static char _pvcs_hdr[] =
"$Header:   I:/ETSTJAN/CPROG/BEHOLDER/APS/SNMP/VCS/SNMP.C_V   1.5   20 Mar 1991 13:35:32   etstjan  $";
#endif
#include <stdio.h>  
#include <stdlib.h>                          /* for NULL */
#include <string.h>
#include <time.h>                           /* for initializing start time */
#include <power3.h>                         /* for pw_*()                  */
#include <error.h>
#include <beholder.h>                       /* for DP structures           */

char *BeholderDate = __DATE__;
char *BeholderDescription  = "Fergy  DNPAP Network Management Monitor  TU Delft";

int IPStackInit(void);
void main(int argc, char **argv);
static int DpMain(void);


static int DpMain(void)
{
  int   ret;

    ret = DpStart();
    if (ret == 0)
        DpLoop();
    pw_waiton();
    DpStop();
    pw_waitoff();
    return ret;
} 

#ifdef __TURBOC__
extern unsigned _stklen = 8*1024;		/* make 8K stack for borland C */
#endif

void main(int argc, char **argv)
{
    int Ind, Ret = 0;
    char Hdr[80];

    for (Ind = 0; Ind < argc; Ind++)
    {
        if (strcmp(argv[Ind], "-f") == 0)
        {
            strcpy(ConfigFile, argv[Ind + 1]);
            break;
        }
    }
    /* initialize buffer lists, device lists and application lists */
    pw_options(argc, argv);
    Ret = pw_init(argv[0], NULL);
    if (Ret)
    {
        fprintf (stderr, "Can not initialize window system\n");
        exit (1);
    }
    sprintf (Hdr, "%s  %s", BeholderDescription, BeholderDate);
    pw_block(pw_win(PWID_BACKGROUND), -1, -1, 1, 80, PWT_REVERSE);    
    pw_header(Hdr);    
    pw_waiton();
    Ret = ERR_INI();
    if (Ret)
    {
        pw_waitoff();                    
        pw_error("Can not initialize errors");
        pw_quit();
        exit (1);
    }
    Ret = BufInit();
    if (Ret)
    {
        pw_waitoff();                    
        pw_error("Can not initialize buffers");
        pw_quit();
        exit (1);
    }
    Ret = DpInit();
    if (Ret)
    {
        pw_waitoff();                    
        pw_error("Can not initialize dispatcher");
        pw_quit();
        exit (1);
    }
    Ret = IPStackInit();
    if (Ret)
    {
        pw_waitoff();                    
        pw_error("Can not initialize IP stack");
        DpEnd();
        pw_quit();
        exit (1);
    }
    pw_waitoff();
    DpMain ();
    DpEnd();
    pw_quit();
    exit (0);
}


