#************************************************************************
#* MODULE INFORMATION*
#*********************
#*     FILE     NAME:       fergie.mak
#*     SYSTEM   NAME:       FERGY
#*     ORIGINAL AUTHOR(S):  Jan van Oorschot
#*     VERSION  NUMBER:     1.00
#*     CREATION DATE:       16-10-90
#*
#* DESCRIPTION:
#************************************************************************
#* CHANGES INFORMATION **
#************************
#* REVISION:    $Revision:$                     
#* WORKFILE:    $Workfile:$
#* LOGINFO:     $Log:$
#************************************************************************
HOMEDIR = .\
NEWTREE = .^\
MODEL=L
MODE=r
CFLAGS=/W4 /Oxaz /A$(MODEL) /L$(MODE) /I$(HOMEDIR)\INCLUDE /I..\INCLUDE /Fmsnmp.map /DPRD
LFLAGS=/MAP /STACK:8000  
MFLAGS = HOMEDIR="$(HOMEDIR)" CFLAGS="$(CFLAGS)" LFLAGS="$(LFLAGS)" MODE=$(MODE) MODEL=$(MODEL)
ID=$(HOMEDIR)\INCLUDE
LD=$(HOMEDIR)\LIB
LIB=$(LD);$(LIB)
ED=$(HOMEDIR)\EXE
PUTNOTE="No explicit note"

SYSTEM=fergie

ALIBS = $(MODEL)POWER3$(MODE).LIB 

BLIBS= $(MODEL)PKT$(MODE).LIB    $(MODEL)DP$(MODE).LIB \
      $(MODEL)ML$(MODE).LIB \
      $(MODEL)IP$(MODE).LIB     $(MODEL)TFTP$(MODE).LIB \
      $(MODEL)FUTIL$(MODE).LIB  $(MODEL)BUFM$(MODE).LIB \
      $(MODEL)PING$(MODE).LIB   $(MODEL)ECHO$(MODE).LIB \
      $(MODEL)DPERR$(MODE).LIB  $(MODEL)CLERR$(MODE).LIB \
      $(MODEL)ASN1$(MODE).LIB \
      $(MODEL)SNMP$(MODE).LIB   $(MODEL)MIB2$(MODE).LIB \
      $(MODEL)DSNMP$(MODE).LIB  $(MODEL)STAT$(MODE).LIB \
      $(MODEL)LOAD$(MODE).LIB   $(MODEL)PROFIL$(MODE).LIB

PARTS= BEHOLDER POWER ML ERROR FUTIL BUFM UDPIP SNMP NPD BFILT SDM BAPS APS

LIBS = $(ALIBS) $(BLIBS)

CS=
AS=
CTS=
HS=
MAKS=fergie.mak
DOCS=
SRCS=$(MAKS) $(CS) $(AS) $(HS) $(DOCS) $(CTS) 
OBJS=
TOBJS=
EXES=
TEXES= 
EXPORTS= 
#************************************************************************
#*  Supported make commands:
#*
#*      all     -->     do a full make of this system part
#*      compile -->     do a compile of all c-files
#*      lib     -->     collect all obj's in a lib
#*      exe     -->     make exe's
#*      clean   -->     throw out all garbage
#*      collect -->     copy all .lib and .h files to global directories
#*      put     -->     do a PVCS put of the sources 
#*      get     -->     do a PVCS get of the sources
#*      getlock -->     do a PVCS get of the sources and put a lock on them
#*      makedir -->     Make all subdirectories in the given
#*                      tree $(NEWTREE)
#************************************************************************
all:
    $(MAKE) /NOLOGO /F $(SYSTEM).mak MOPT=$* $(PARTS) 
    $(MAKE) /NOLOGO /F $(SYSTEM).mak $*.own 

clean collect get put getlock makedir:  
    $(MAKE) /NOLOGO /F $(SYSTEM).mak MOPT=$* $(PARTS) 
    $(MAKE) /NOLOGO /F $(SYSTEM).mak $*.own 

$(PARTS) :
    @cd $*
    @echo (1) $* Build
    @$(MAKE) /NOLOGO /F $*.mak $(MOPT)
    @echo (1) $* Ready
    @cd ..
    

all.own: 
    @echo Start make all

clean.own:
    @-del *.obj 2>nul
    @-del *.lib 2>nul
    @-del *.bak 2>nul
    @-del *.err 2>nul
    @-del *.exe 2>nul


collect.own: $(EXPORTS)


put.own:    $(SRCS)
    !@-PUT -l -n -mt$(PUTNOTE) $**
    @-PUT  -l -n -mt$(PUTNOTE) $(SYSTEM).mak

getlock.own:    $(SRCS)
    !-GET -l $**


get.own:    $(SRCS)
    !GET  $**

makedir.own:
    mkdir $(NEWTREE)\VCS

#************************************************************************
#*  actual components and relations
#************************************************************************
#$(SRCS) :

#$(EXPORTS) :

#************************************************************************
#*  Libraries in beholder system
#************************************************************************
$(MODEL)PKT$(MODE).LIB:
    echo $@ 

$(MODEL)DP$(MODE).LIB :
    echo $@ 

$(MODEL)POWER3$(MODE).LIB       :
    echo $@ 

$(MODEL)ML$(MODE).LIB :
    echo $@ 

$(MODEL)IP$(MODE).LIB     :
    echo $@ 

$(MODEL)TFTP$(MODE).LIB :
    echo $@ 

$(MODEL)FUTIL$(MODE).LIB:
    echo $@ 

$(MODEL)BUFM$(MODE).LIB :
    echo $@ 

$(MODEL)PING$(MODE).LIB:
    echo $@ 

$(MODEL)ECHO$(MODE).LIB :
    echo $@ 

$(MODEL)ERROR$(MODE).LIB:
    echo $@ 

$(MODEL)ASN1$(MODE).LIB :
    echo $@ 

$(MODEL)SNMP$(MODE).LIB :
    echo $@ 

$(MODEL)MIB2$(MODE).LIB :
    echo $@ 

$(MODEL)DSNMP$(MODE).LIB:
    echo $@ 

$(MODEL)STAT$(MODE).LIB :
    echo $@ 

$(MODEL)LOAD$(MODE).LIB :
    echo $@ 

$(MODEL)PROFIL$(MODE).LIB:
    echo $@ 

