/************************************************************************
** MODULE INFORMATION*
**********************
**     FILE     NAME:       DPFILT.C
**     SYSTEM   NAME:       PACKET DISPATCHER
**     ORIGINAL AUTHOR(S):  Ling Thio
**     VERSION  NUMBER:     v1.00
**     CREATION DATE:       1989/11/30
**
** DESCRIPTION: Dispatcher's filter controll functions
**              
*************************************************************************
** CHANGES INFORMATION **
*************************
** REVISION:    $Revision:   1.0  $
** WORKFILE:    $Workfile:   DPFILT.C  $
** LOGINFO:     $Log:   I:/ETSTJAN/C600/BEHOLDER/NPD/DP/VCS/DPFILT.C_V  $
**              
**                 Rev 1.0   26 Oct 1990 12:28:04   etstjan
**              Initial revision.
*************************************************************************/
#if ! defined(PRD)
static char _pvcs_hdr[] =
"$Header:   I:/ETSTJAN/C600/BEHOLDER/NPD/DP/VCS/DPFILT.C_V   1.0   26 Oct 1990 12:28:04   etstjan  $";
#endif

#include <stdlib.h>
#include <error.h>
#include "dpinc.h"

static int DpFiltCount;

int DpFiltInit (void)
{
    int Ret = 0;
    int Filt;
    DPFILT *pFilt;

    ERR_DEB(ERR_NPD, 4, "DpFiltInit");
    for (DpFiltCount=0;DpFiltAvailable[DpFiltCount];DpFiltCount++);
    for (Filt=0;Filt<DpFiltCount;Filt++)
    {
        pFilt=DpFiltAvailable[Filt];
        pFilt->Status= DPE_END + DPE_STOP;
        DpFiltEvent (Filt, DPE_INIT);
    }
    return Ret;
}

void DpFiltEnd (void)
{
    int Filt;

    ERR_DEB(ERR_NPD, 4, "DpFiltEnd");
    for (Filt=0; Filt<DpFiltCount; Filt++)
    {
        DpFiltEvent (Filt, DPE_END);
    }
}


int DpFiltFilter (int Filt)
{
    return (*(DpFiltAvailable[Filt]->pProcessEventFunction))(DPE_RECEIVEPKT);
}


int DpFiltEvent (int Filt, int Event)
{
    int Ret = 0;
    DPFILT *pFilt = DpFiltAvailable[Filt];

    if (!(pFilt->Status & Event))
    {
        Ret = (*(pFilt->pProcessEventFunction))(Event);
        switch (Event)
        {
            case DPE_START:
                pFilt->Status |= DPE_START;
                pFilt->Status &= ~DPE_STOP;
                break;
            case DPE_STOP:
                pFilt->Status |= DPE_STOP;
                pFilt->Status &= ~DPE_START;
                break;
            case DPE_INIT:
                pFilt->Status |= DPE_INIT;
                pFilt->Status &= ~DPE_END;
                break;
            case DPE_END:
                pFilt->Status |= DPE_END;
                pFilt->Status &= ~DPE_INIT;
                break;
        }
    }
    return Ret;
}



int DpFiltGetCount (void)
{
    return (DpFiltCount);
}

int *DpFiltGetStatus (int Filt)
{
    if (Filt<0 || Filt>=DpFiltCount)
        return (NULL);
    return (&(DpFiltAvailable[Filt]->Status));
}

char *DpFiltGetName (int Filt)
{
    if (Filt<0 || Filt>=DpFiltCount)
        return (NULL);
    return (DpFiltAvailable[Filt]->Name);
}
