/************************************************************************
** MODULE INFORMATION*
**********************
**     FILE     NAME:       DPUDUMP.C
**     SYSTEM   NAME:       PACKET DISPATCHER
**     ORIGINAL AUTHOR(S):  Ling Thio
**     VERSION  NUMBER:     v1.00
**     CREATION DATE:       1989/11/30
**
** DESCRIPTION: Functions to select a data file
**              
*************************************************************************
** CHANGES INFORMATION **
*************************
** REVISION:    $Revision:   1.0  $
** WORKFILE:    $Workfile:   DPUFILE.C  $
** LOGINFO:     $Log:   I:/ETSTJAN/C600/BEHOLDER/NPD/DPU/VCS/DPUFILE.C_V  $
**              
**                 Rev 1.0   25 Oct 1990 15:26:50   etstjan
**              Initial revision.
*************************************************************************/
#include <stdio.h>
#include <string.h>
#include <stdlib.h>                         /* for _MAX_PATH */
#include <direct.h>                         /* for getcwd() */
#include "dpuinc.h"                         /* main include file */

#define MAX_FILES       128

/************************************************************************
** NAME:        DpuGetFile
** SYNOPSIS:    PWKEY DpuGetFile(header,filemask,fname,OldElem)
**              char *header        Power header text
**              char *filemask      Select file mask (*.DMP)
**              char *fname         Return buffer for file
**              int  *OldElem       Place of cursor
** DESCRIPTION: Lets the user select a file from 'filemask'.
** RETURNS:     PWK_ENTER: Selection in 'fname'.
**              PWK_ESC:   User canceled selection.
*************************************************************************/
PWKEY DpuGetFile(header, filemask, fname, OldElem)
char *header;
char *filemask;
char *fname;
int *OldElem;
{
    PWWIN *InpWin;
    int ret = -1;
    char mask[_MAX_PATH];

    if (!getcwd(mask, _MAX_PATH-14))
        *mask = '\0'; 
    else
    {
        if (mask[strlen(mask)-1] != '\\')
            strcat(mask, "\\");
    }
    strncat(mask, filemask, _MAX_PATH);
    InpWin = pw_open(14, 4, 1, 52, header, PWM_DEFAULT, PWW_NORMAL);
    pw_shade(InpWin);
    while ((ret) && (pw_input(InpWin, 0, 0, "", 0, 1, pw_winncol(InpWin)-2, mask, _MAX_PATH, NULL, PWM_UPROMPT) != PWK_ESC))
        ret = pw_selectfile(14, 58, 7, MAX_FILES, OldElem, mask, fname);
    pw_close(InpWin);
    return (ret) ? PWK_ESC : PWK_ENTER;
}

