/*
 *      JET PAK - HP DeskJet and LaserJet series printer utilities
 *
 *      JETFONT header - soft font utility definitions
 *
 *      Version 1.1 (Public Domain)
 */

/* Conversion between units */
#define dots_to_points(d)         (((float)(d) * 6.0)/25.0)
#define quarter_dots_to_points(d) (((float)(d) * 6.0)/100.0)
#define quarter_dots_to_lpi(d)    ((d) == 0 ? 0.0 : (1200.0/(float)(d)))

/*
 * FONT FILE DEFINITIONS
 */

/* Field types */
typedef unsigned char  BOOLEAN;
typedef unsigned char  UNSIGNEDBYTE;
typedef          char  SIGNEDBYTE;
typedef unsigned short UNSIGNEDINT;
typedef          short SIGNEDINT;
typedef          char  ASC16[16];

/* Font descriptor structure (command_type == FDC) ... */
#define COMMENT_SIZE_MAX 800
typedef struct font_descriptor_struct
{
    UNSIGNEDINT  size;
    UNSIGNEDBYTE header_format;
    UNSIGNEDBYTE type;
    UNSIGNEDINT  reserved1;
    UNSIGNEDINT  baseline_distance;
    UNSIGNEDINT  cell_width;
    UNSIGNEDINT  cell_height;
    UNSIGNEDBYTE orientation;
    BOOLEAN spacing;
    UNSIGNEDINT  symbol_set;
    UNSIGNEDINT  pitch;
    UNSIGNEDINT  height;
    UNSIGNEDINT  x_height;
    SIGNEDBYTE   width_type;
    UNSIGNEDINT  style;
    SIGNEDBYTE   stroke_weight;
    UNSIGNEDINT  typeface;
    UNSIGNEDBYTE slant;
    UNSIGNEDBYTE serif_style;
    UNSIGNEDBYTE quality;
    SIGNEDBYTE   placement;
    SIGNEDBYTE   underline_distance;
    UNSIGNEDBYTE underline_height;
    UNSIGNEDINT  text_height;
    UNSIGNEDINT  text_width;
    UNSIGNEDINT  first_code;
    UNSIGNEDINT  last_code;
    UNSIGNEDBYTE pitch_extended;
    UNSIGNEDBYTE height_extended;
    UNSIGNEDINT  reserved2;
    UNSIGNEDINT  font_number_top;
    UNSIGNEDINT  font_number_bot;
    ASC16        name;
    UNSIGNEDINT  h_pixel_resolution;
    UNSIGNEDINT  v_pixel_resolution;
    SIGNEDBYTE   tdu_distance;
    UNSIGNEDBYTE tdu_height;
    SIGNEDBYTE   bdu_distance;
    UNSIGNEDBYTE bdu_height;
    UNSIGNEDINT  specific_size;
    UNSIGNEDINT  data_size;
    BOOLEAN      unidirection;
    BOOLEAN      compressed;
    UNSIGNEDBYTE hold_time_factor;
    BOOLEAN      no_half_pitch;
    BOOLEAN      no_double_pitch;
    BOOLEAN      no_half_height;
    BOOLEAN      no_bold;
    BOOLEAN      no_draft;
    BOOLEAN      bold_method;
    UNSIGNEDBYTE reserved3;
    UNSIGNEDINT  baseline_offset_2;
    UNSIGNEDINT  baseline_offset_3;
    UNSIGNEDINT  baseline_offset_4;
    ASC16        name_extension;
    char         comment[COMMENT_SIZE_MAX];
} FONT_DESCRIPTOR;

    /* ... and constants associated with various fields */
#define LJFDSIZE            64  /* .size in LJ font file */
#define DJFDSIZE            72  /* .size in DJ/DJ+ font files */
#define DJ500FDSIZE         74  /* .size in DJ500 font file */

#define LJFONTFORMAT        0   /* .header_format in LJ font file */
#define DJFONTFORMAT        5   /* .header_format in DJ font file */
#define DJPFONTFORMAT       9   /* .header_format in DJ+ font file */
#define DJ500FONTFORMAT     12  /* .header_format in DJ500 font file */

#define FONT_TYPE_7BIT      0   /* .type in a 7-bit font */
#define FONT_TYPE_8BIT      1   /* .type in a 8-bit font */
#define FONT_TYPE_IBM       2   /* .type in a IBM font */

#define FIXED               0   /* .spacing fixed */
#define PROPORTIONAL        1   /* .spacing proportional */

#define PORTRAIT            0   /* .orientation portrait */
#define LANDSCAPE           1   /* .orientation landscape */

#define LJSSIZE             0   /* .specific_size in LJ font file */
#define DJSSIZE             20  /* .specific_size in DJ font file */
#define DJ500SSIZE          36  /* .specific_size in DJ500 font file */

#define MULTI_PASS_OFFSET   48  /* approved dot offset between DJ passes */

    /* ... height of the individual pass bitmaps; the pass bitmaps
           overlap by 2 bits, which in the top pass(es) should be clear */
#define PASS_OVERLAP    2
#define PASS_HEIGHT     (MULTI_PASS_OFFSET + PASS_OVERLAP)

    /* ... number of lines usable for data in each DJ pass */
#define lines_for_pass(pass) (pass==0?PASS_HEIGHT:MULTI_PASS_OFFSET)

    /* ... largest design cell usable on the DeskJet series */
#define MAX_CELL_HEIGHT (PASS_HEIGHT + MULTI_PASS_OFFSET*3)
#define MAX_CELL_WIDTH  254

    /* ... range in which underlines may lie on DJ */
#define UNDERLINE_MAX   PASS_HEIGHT
#define UNDERLINE_MIN   (UNDERLINE_MAX-12)

    /* ... rule of thumb to calculate underline height */
#define underline_height_for_height(h) (h/64)

    /* ... rule of thumb to calculate hold time factor */
#define hold_time_factor_for_height(h) (h/3)

/* Character Descriptor structure (command_type == CDC) ... */
#define BITMAP_SIZE_MAX 8000
typedef struct character_descriptor_struct
{
    UNSIGNEDBYTE format;
    BOOLEAN      continuation;
    union character_descriptor_data {
        struct ljchar_struct {
            UNSIGNEDBYTE descriptor_size;
            UNSIGNEDBYTE class;
            UNSIGNEDBYTE orientation;
            UNSIGNEDBYTE reserved;
            SIGNEDINT    left_offset;
            SIGNEDINT    top_offset;
            UNSIGNEDINT  character_width;
            UNSIGNEDINT  character_height;
            SIGNEDINT    delta_x;
            UNSIGNEDBYTE bitmap[BITMAP_SIZE_MAX];
        } ljchar;

        struct djchar_struct {
            UNSIGNEDBYTE descriptor_size;
            UNSIGNEDBYTE char_type;
            UNSIGNEDBYTE character_width;
            UNSIGNEDBYTE comp_width;
            SIGNEDBYTE   left_offset;
            SIGNEDBYTE   right_offset;
            UNSIGNEDBYTE bitmap[BITMAP_SIZE_MAX];
        } djchar;
    } data;
} CHARACTER_DESCRIPTOR;

    /* ... and constants associated with various fields */
#define LJCHARFORMAT        4   /* .format in LJ font file */
#define DJCHARFORMAT        5   /* .format in DJ font file */
#define DJPCHARFORMAT       9   /* .format in DJ+ font file */
#define DJ500CHARFORMAT     12  /* .format in DJ500 font file */

#define LJCDSIZE            14  /* .descriptor_size in LJ font file */
#define DJCDSIZE            6   /* .descriptor_size in DJ font file */

#define CHAR_TYPE_NORMAL    0   /* .char_type values in DJ font */
#define CHAR_TYPE_PASS1     2
#define CHAR_TYPE_PASS2     3
#define CHAR_TYPE_PASS3     4
#define CHAR_TYPE_PASS4     5

    /* macros to convert between char_type values and useful numbers */
#define char_type_for_pass(pass) (pass + 2)
#define pass_for_char_type(type) (type == CHAR_TYPE_NORMAL?type:type - 2)

/* Generic font command structure */
typedef struct font_command_struct {
    int command_type;
    int number;
    union font_command_data {
        FONT_DESCRIPTOR      font;
        CHARACTER_DESCRIPTOR character;
    } data;
} FONT_COMMAND;

/* Font command escape sequences */
#define FDC     0           /* .command_type for font descriptor */
#define FDC_S   ")s"        /* font descriptor command start */
#define FDC_E   "W"         /* font descriptor command end */

#define CCC     (FDC+1)     /* .command_type for character code */
#define CCC_S   "*c"        /* character code command start */
#define CCC_E   "E"         /* character code command end */

#define CDC     (CCC+1)     /* .command_type for character descriptor */
#define CDC_S   "(s"        /* character descriptor command start */
#define CDC_E   "W"         /* character descriptor command end */

/*
 * DEFINITIONS FOR DUMP FORMAT
 */

#define COMMENT_CHARACTER   '#'
#define KEYWORD_CHARACTER   '$'

#define KEYWORD_FILE        "$FILE"
#define KEYWORD_HEADER      "$HEADER"
#define KEYWORD_NAME        "$NAME"
#define KEYWORD_COMMENT     "$COMMENT"
#define KEYWORD_CHAR        "$CHAR"
#define KEYWORD_BITMAP      "$BITMAP"

/*
 * DECLARATIONS OF PUBLIC FUNCTIONS
 */

/* Utility functions */
extern int  font_command_read();
extern int  font_command_write();
