/*
 *      JET PAK - HP DeskJet and LaserJet series printer utilities
 *
 *      JETUTIL header - miscellaneous utility definitions
 *
 *      Version 1.1 (Public Domain)
 */

/* useful definitions */
#define sizeofarray(a) (sizeof(a)/sizeof(a[0]))
#define FALSE 0
#define TRUE !FALSE

/* returns from functions (EOF is picked up from <stdio.h>) */
#define OK      0
#define ERROR   -2

/* general messages */
#define ERROR_NO_FILES_MATCHED  "ERROR: no files found matching \"%s\"\n"
#define ERROR_OPTION_BAD        "ERROR: option -%c unrecognised\n"
#define ERROR_OPTION_NO_ARG     "ERROR: option -%c requires an argument\n"
#define ERROR_OUT_OF_HEAP       "ERROR: not enough heap to process arguments\n"

/* messages relating to processing of a particular file */
#define ERROR_BITMAP_TOO_BIG    "%s%s: ERROR: bitmap too big to handle\n"
#define ERROR_CODE_TOO_BIG      "%s%s: ERROR: character code %d too big to handle\n"
#define ERROR_CONTINUATION      "%s%s: ERROR: font contains continuation data\n"
#define ERROR_DATA_MISSING      "%s%s: ERROR: missing data at line %d\n"
#define ERROR_DESKJET           "%s%s: ERROR: input file is already in DeskJet format\n"
#define ERROR_FILE_READ_FAILED  "%s%s: ERROR: problem reading input file\n"
#define ERROR_FILE_WRITE_FAILED "%s%s: ERROR: problem writing output file\n"
#define ERROR_FONT_OUT_OF_HEAP  "%s%s: ERROR: not enough heap to process font\n"
#define ERROR_FONT_TOO_BIG      "%s%s: ERROR: font too big to handle\n"
#define ERROR_KEYWORD_MISSING   "%s%s: ERROR: missing keyword at line %d\n"
#define ERROR_LANDSCAPE_FIXED   "%s%s: ERROR: only fixed width landscape fonts convertible\n"
#define ERROR_LASERJET          "%s%s: ERROR: input file is already in LaserJet format\n"
#define ERROR_OPEN_READ_FAILED  "%s%s: ERROR: can't open for reading\n"
#define ERROR_OPEN_WRITE_FAILED "%s%s: ERROR: can't open \"%s\" for writing\n"
#define ERROR_OVERWRITE         "%s%s: ERROR: output file will overwrite input file\n"
#define WARNING_BAD_FONT_FORMAT "%s%s: WARNING: unrecognised font format %d\n"
#define WARNING_BAD_CHAR_FORMAT "%s%s: WARNING: unrecognised character format %d\n"
#define WARNING_COMMAND_SKIPPED "%s%s: WARNING: skipping ESC %s %d %s\n"
#define WARNING_DJ_LANDSCAPE    "%s%s: WARNING: landscape font unusable on original Deskjet\n"
#define WARNING_DJ_TOO_LARGE    "%s%s: WARNING: output font too large for original Deskjet\n"
#define WARNING_DJ500_ONLY      "%s%s: WARNING: output font can only be used on the DeskJet 500\n"
#define WARNING_SIDE_BEARING    "%s%s: WARNING: %s negative side bearing lost (%d for %s worst)\n"
#define WARNING_STRING_NL       "%s%s: WARNING: string not terminated at end of line %d\n"
#define WARNING_TOKEN_OVERFLOW  "%s%s: WARNING: token overflow at line %d\n"

/* comfort messages when there are no errors */
#define OK_JETDMP   "%s%s: dump file \"%s\" generated OK\n"
#define OK_JETL2D   "%s%s: DJ soft font file \"%s\" generated OK\n"
#define OK_JETD2L   "%s%s: LJ soft font file \"%s\" generated OK\n"
#define OK_JETPRD   "%s%s: printer description file \"%s\" generated OK\n"
#define OK_JETPRINT "%s%s: output sent to printer\n"
#define OK_JETRST   "%s%s: soft font file \"%s\" restored OK\n"

/* these string are appended to the soft font header comment as JETPAK
   signatures */
#define JETL2D_COMMENT_SUFFIX " (JETL2D conversion) "
#define JETD2L_COMMENT_SUFFIX " (JETD2L conversion) "

/* maximum length of user defined output file suffix */
#define SUFFIX_MAX  32

/* definitions for option processing utility functions */
extern char *optarg;
extern int optind, opterr;
extern int getopt();

/* definitions for directory search utility functions; os_getfile() sets
   os_file and os_dir to point to the next matching file to be processed */
#define OS_DIR_LEN 256
#define OS_FILE_LEN 64
#define OS_PATH_LEN (OS_DIR_LEN + OS_FILE_LEN - 1)
extern char *os_dir;
extern char *os_file;
extern int os_findfiles();
extern int os_getfile();

/* definitions for printing utility functions */
extern void os_printbuf();
extern void os_printstr();

/* definitions for memory allocation functions */
extern void *zalloc();
